/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.home;

import io.github.sakurawald.core.auxiliary.minecraft.PermissionHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.core.structure.SpatialPose;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.home.command.argument.wrapper.HomeName;
import io.github.sakurawald.module.initializer.home.config.model.HomeDataModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class HomeInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<HomeDataModel> storage = new ObjectConfigurationHandler<HomeDataModel>("home.json", HomeDataModel.class).autoSaveEveryMinute();

    public static Map<String, SpatialPose> withHomes(@NotNull class_3222 player) {
        String playerName = player.method_7334().getName();
        Map<String, Map<String, SpatialPose>> homes = HomeInitializer.storage.model().name2home;
        homes.computeIfAbsent(playerName, k -> new HashMap());
        return homes.get(playerName);
    }

    @CommandNode(value="home tp")
    private static int $tp(@CommandSource class_3222 player, HomeName home) {
        Map<String, SpatialPose> homes = HomeInitializer.withHomes(player);
        String homeName = (String)home.getValue();
        HomeInitializer.ensureHomeExists(player, homes, homeName);
        SpatialPose spatialPose = homes.get(homeName);
        spatialPose.teleport(player);
        return 1;
    }

    private static void ensureHomeExists(class_3222 player, Map<String, SpatialPose> homes, String homeName) {
        if (!homes.containsKey(homeName)) {
            TextHelper.sendMessageByKey(player, "home.not_found", homeName);
            throw new AbortCommandExecutionException();
        }
    }

    @CommandNode(value="home unset")
    private static int $unset(@CommandSource class_3222 player, HomeName home) {
        Map<String, SpatialPose> homes = HomeInitializer.withHomes(player);
        String homeName = (String)home.getValue();
        HomeInitializer.ensureHomeExists(player, homes, homeName);
        homes.remove(homeName);
        TextHelper.sendMessageByKey(player, "home.unset.success", homeName);
        return 1;
    }

    @CommandNode(value="home set")
    private static int $set(@CommandSource class_3222 player, HomeName home, Optional<Boolean> override) {
        String homeName;
        Map<String, SpatialPose> name2position = HomeInitializer.withHomes(player);
        if (name2position.containsKey(homeName = (String)home.getValue()) && !override.orElse(false).booleanValue()) {
            TextHelper.sendMessageByKey(player, "home.set.fail.need_override", homeName);
            return -1;
        }
        Optional<Integer> limit = PermissionHelper.getMeta(player.method_5667(), "fuji.home.home_limit", Integer::valueOf);
        if (limit.isPresent() && name2position.size() >= limit.get()) {
            TextHelper.sendMessageByKey(player, "home.set.fail.limit", new Object[0]);
            return -1;
        }
        name2position.put(homeName, SpatialPose.of(player));
        TextHelper.sendMessageByKey(player, "home.set.success", homeName);
        return 1;
    }

    @CommandNode(value="home list")
    private static int $list(@CommandSource class_3222 player) {
        TextHelper.sendMessageByKey(player, "home.list", HomeInitializer.withHomes(player).keySet());
        return 1;
    }

    public static BaseConfigurationHandler<HomeDataModel> getStorage() {
        return storage;
    }
}

