/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.kit.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.gui.InputSignGui;
import io.github.sakurawald.core.gui.PagedGui;
import io.github.sakurawald.module.initializer.kit.KitInitializer;
import io.github.sakurawald.module.initializer.kit.structure.Kit;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_747;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KitEditorGui
extends PagedGui<Kit> {
    public KitEditorGui(class_3222 player, @NotNull List<Kit> entities, int pageIndex) {
        super(null, player, TextHelper.getTextByKey(player, "kit.gui.editor.title", new Object[0]), entities, pageIndex);
        this.getFooter().setSlot(1, (GuiElementBuilderInterface)GuiHelper.makeHelpButton(player).setLore(TextHelper.getTextListByKey(player, "kit.gui.editor.help.lore")));
        this.getFooter().setSlot(4, GuiHelper.makeAddButton(player).setCallback(() -> new InputSignGui(player, TextHelper.getTextByKey(player, "prompt.input.name", new Object[0])){

            public void onClose() {
                String name = this.getLine(0).getString().trim();
                if (name.isEmpty()) {
                    TextHelper.sendActionBarByKey(this.player, "operation.cancelled", new Object[0]);
                    return;
                }
                KitEditorGui.this.openKitEditingGui(this.getPlayer(), KitInitializer.readKit(name));
            }
        }.open()));
    }

    private void openKitEditingGui(@NotNull class_3222 player, final @NotNull Kit kit) {
        int i2;
        int rows = 5;
        final class_1277 simpleInventory = new class_1277(rows * 9);
        for (i2 = 0; i2 < kit.getStackList().size(); ++i2) {
            simpleInventory.method_5447(i2, kit.getStackList().get(i2));
        }
        if (simpleInventory.method_5442()) {
            simpleInventory.method_5447(0, class_1802.field_8371.method_7854());
            class_1799 food = class_1802.field_8229.method_7854();
            food.method_7939(16);
            simpleInventory.method_5447(1, food);
            simpleInventory.method_5447(36, class_1802.field_8660.method_7854());
            simpleInventory.method_5447(37, class_1802.field_8396.method_7854());
            simpleInventory.method_5447(38, class_1802.field_8523.method_7854());
            simpleInventory.method_5447(39, class_1802.field_8743.method_7854());
            simpleInventory.method_5447(40, class_1802.field_8255.method_7854());
        }
        for (i2 = 41; i2 <= 44; ++i2) {
            simpleInventory.method_5447(i2, GuiHelper.makeBarrier().getItemStack());
        }
        class_747 simpleNamedScreenHandlerFactory = new class_747((i, playerInventory, p) -> new class_1707(this, class_3917.field_18667, i, playerInventory, (class_1263)simpleInventory, rows){

            public void method_7593(int i, int j, class_1713 slotActionType, class_1657 playerEntity) {
                if (GuiHelper.isInvalidSlotInsidePlayerInventory(i)) {
                    return;
                }
                super.method_7593(i, j, slotActionType, playerEntity);
            }

            public void method_7595(class_1657 playerEntity) {
                super.method_7595(playerEntity);
                ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
                for (int j = 0; j < simpleInventory.method_5439(); ++j) {
                    itemStacks.add(simpleInventory.method_5438(j));
                }
                KitInitializer.writeKit(kit.withStackList(itemStacks));
            }
        }, TextHelper.getTextByKey(player, "kit.gui.editor.kit.title", kit.getName()));
        player.method_17355((class_3908)simpleNamedScreenHandlerFactory);
    }

    @Override
    protected PagedGui<Kit> make(@Nullable SimpleGui parent, class_3222 player, class_2561 title, @NotNull List<Kit> entities, int pageIndex) {
        return new KitEditorGui(player, entities, pageIndex);
    }

    @Override
    protected GuiElementInterface toGuiElement(@NotNull Kit entity) {
        return ((GuiElementBuilder)new GuiElementBuilder().setItem(class_1802.field_8106).setName((class_2561)class_2561.method_43470((String)entity.getName())).setCallback(event -> {
            if (event.isLeft) {
                this.openKitEditingGui(this.getPlayer(), entity);
            }
            if (event.shift && event.isRight) {
                KitInitializer.deleteKit(entity.getName());
                this.deleteEntity(entity);
                TextHelper.sendActionBarByKey(this.getPlayer(), "deleted", new Object[0]);
            }
        })).build();
    }

    @Override
    @NotNull
    protected List<Kit> filter(@NotNull String keyword) {
        return this.getEntities().stream().filter((? super T e) -> e.getName().contains(keyword)).toList();
    }
}

