/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.profiler;

import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class ProfilerInitializer
extends ModuleInitializer {
    @NotNull
    private static String formatBytes(long bytes) {
        if (bytes == -1L) {
            return "N/A";
        }
        if (bytes < 1024L) {
            return bytes + "B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.2fK", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%.2fM", (double)bytes / 1048576.0);
        }
        return String.format("%.2fG", (double)bytes / 1.073741824E9);
    }

    @CommandNode(value="profiler")
    @Document(value="Query the server health status.")
    private static int $profiler(@CommandSource CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        CompletableFuture.runAsync(() -> {
            String os_name = ManagementFactory.getOperatingSystemMXBean().getName();
            String os_version = ManagementFactory.getOperatingSystemMXBean().getVersion();
            String os_arch = ManagementFactory.getOperatingSystemMXBean().getArch();
            String vmName = ManagementFactory.getRuntimeMXBean().getVmName();
            String vmVersion = ManagementFactory.getRuntimeMXBean().getVmVersion();
            class_5250 gcText = TextHelper.getTextByKey(source, "profiler.format.gc.head", new Object[0]).method_27661();
            List<GarbageCollectorMXBean> gcMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
            long uptime = ManagementFactory.getRuntimeMXBean().getUptime();
            int i = 0;
            for (GarbageCollectorMXBean gcMXBean : gcMXBeans) {
                String name = gcMXBean.getName();
                long totalGcTime = gcMXBean.getCollectionTime();
                long totalGcCount = gcMXBean.getCollectionCount();
                double avgFrequency = (double)uptime / (double)totalGcCount / 1000.0;
                double avgTime = (double)totalGcTime / (double)totalGcCount;
                gcText = gcText.method_10852(TextHelper.getTextByKey(source, i == gcMXBeans.size() - 1 ? "profiler.format.gc.last" : "profiler.format.gc.no_last", name, avgFrequency, avgTime, totalGcCount, totalGcTime));
                ++i;
            }
            class_5250 memText = TextHelper.getTextByKey(source, "profiler.format.mem.head", new Object[0]).method_27661();
            List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
            i = 0;
            for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
                String name = memoryPoolMXBean.getName();
                MemoryType type = memoryPoolMXBean.getType();
                MemoryUsage memoryUsage = memoryPoolMXBean.getUsage();
                String init = ProfilerInitializer.formatBytes(memoryUsage.getInit());
                String used = ProfilerInitializer.formatBytes(memoryUsage.getUsed());
                String committed = ProfilerInitializer.formatBytes(memoryUsage.getCommitted());
                String max = ProfilerInitializer.formatBytes(memoryUsage.getMax());
                memText = memText.method_10852(TextHelper.getTextByKey(source, i == memoryPoolMXBeans.size() - 1 ? "profiler.format.mem.last" : "profiler.format.mem.no_last", new Object[]{name, type, init, used, committed, max}));
                ++i;
            }
            class_5250 formatText = TextHelper.getTextByKey(source, "profiler.format", os_name, os_version, os_arch, vmName, vmVersion).method_27661();
            source.method_45068((class_2561)formatText.method_10852(TextHelper.TEXT_NEWLINE).method_10852((class_2561)memText).method_10852(TextHelper.TEXT_NEWLINE).method_10852((class_2561)gcText));
        });
        return 1;
    }
}

