/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.rtp;

import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.command.annotation.CommandTarget;
import io.github.sakurawald.core.command.argument.wrapper.impl.Dimension;
import io.github.sakurawald.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.core.service.random_teleport.RandomTeleporter;
import io.github.sakurawald.core.structure.TeleportSetup;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.rtp.config.model.RtpConfigModel;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class RtpInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<RtpConfigModel> config = new ObjectConfigurationHandler<RtpConfigModel>("config.json", RtpConfigModel.class);

    @NotNull
    private static TeleportSetup withTeleportSetup(@NotNull class_3222 player, @NotNull class_3218 world) {
        List<TeleportSetup> list = RtpInitializer.config.model().setup.dimension;
        String dimension = RegistryHelper.ofString((class_1937)world);
        Optional<TeleportSetup> first = list.stream().filter(o -> o.getDimension().equals(dimension)).findFirst();
        if (first.isEmpty()) {
            TextHelper.sendMessageByKey(player, "rtp.dimension.disallow", RegistryHelper.ofString((class_1937)world));
            throw new AbortCommandExecutionException();
        }
        return first.get();
    }

    @CommandNode(value="rtp")
    @Document(value="Random rtp in specified dimension.")
    private static int $rtp(@CommandSource @CommandTarget class_3222 player, Optional<Dimension> dimension) {
        class_3218 serverWorld = dimension.isPresent() ? (class_3218)dimension.get().getValue() : player.method_51469();
        TeleportSetup setup = RtpInitializer.withTeleportSetup(player, serverWorld);
        TextHelper.sendActionBarByKey(player, "rtp.tip", new Object[0]);
        RandomTeleporter.request(player, setup, position -> TextHelper.sendMessageByKey(player, "rtp.success", new Object[0]));
        return 1;
    }
}

