/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.world;

import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.core.annotation.Cite;
import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandRequirement;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.command.argument.wrapper.impl.Dimension;
import io.github.sakurawald.core.command.argument.wrapper.impl.DimensionType;
import io.github.sakurawald.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.core.structure.SpatialPose;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.world.WorldManager;
import io.github.sakurawald.module.initializer.world.config.model.WorldConfigModel;
import io.github.sakurawald.module.initializer.world.config.model.WorldDataModel;
import io.github.sakurawald.module.initializer.world.gui.WorldGui;
import io.github.sakurawald.module.initializer.world.structure.DimensionNode;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6673;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Cite(value={"https://github.com/NucleoidMC/fantasy"})
@CommandNode(value="world")
@CommandRequirement(level=4)
public class WorldInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<WorldConfigModel> config = new ObjectConfigurationHandler<WorldConfigModel>("config.json", WorldConfigModel.class);
    private static final BaseConfigurationHandler<WorldDataModel> storage = new ObjectConfigurationHandler<WorldDataModel>("world.json", WorldDataModel.class);

    private static void checkBlacklist(CommandContext<class_2168> ctx, String identifier) {
        if (WorldInitializer.config.model().blacklist.dimension_list.contains(identifier)) {
            TextHelper.sendMessageByKey(ctx.getSource(), "world.dimension.blacklist", identifier);
            throw new AbortCommandExecutionException();
        }
    }

    @CommandNode(value="tp")
    @Document(value="Teleport to the spawnpoint of the world.")
    private static int $tp(@CommandSource class_3222 player, Dimension dimension) {
        class_3218 world = (class_3218)dimension.getValue();
        class_2338 spawnPos = world.method_43126();
        new SpatialPose((class_1937)world, (double)spawnPos.method_10263(), (double)spawnPos.method_10264(), (double)spawnPos.method_10260(), player.method_36454(), player.method_36455()).teleport(player);
        return 1;
    }

    @CommandNode(value="list")
    private static int $list(@CommandSource class_2168 source) {
        if (source.method_43737()) {
            List<DimensionNode> entities = WorldInitializer.storage.model().dimension_list;
            new WorldGui(source.method_44023(), entities, 0).open();
        } else {
            ServerHelper.getWorlds().forEach(world -> {
                String dimensionType = world.method_40134().method_55840();
                String dimension = String.valueOf(world.method_27983().method_29177());
                TextHelper.sendMessageByKey(source, "world.dimension.list.entry", dimension, dimensionType);
            });
        }
        return 1;
    }

    @CommandNode(value="create")
    private static int $create(@CommandSource CommandContext<class_2168> ctx, String name, Optional<Long> seed, DimensionType dimensionType) {
        String FUJI_DIMENSION_NAMESPACE = "fuji";
        class_2960 dimensionIdentifier = class_2960.method_60655((String)FUJI_DIMENSION_NAMESPACE, (String)name);
        if (ServerHelper.getWorlds().stream().anyMatch(it -> RegistryHelper.ofString((class_1937)it).equals(dimensionIdentifier.toString()))) {
            TextHelper.sendMessageByKey(ctx.getSource(), "world.dimension.exist", new Object[0]);
            return -1;
        }
        long $seed = seed.orElse(class_6673.method_39001());
        class_2960 dimensionTypeIdentifier = class_2960.method_60654((String)((String)dimensionType.getValue()));
        DimensionNode dimensionNode = new DimensionNode(true, dimensionIdentifier.toString(), dimensionTypeIdentifier.toString(), $seed);
        WorldInitializer.storage.model().dimension_list.add(dimensionNode);
        storage.writeStorage();
        WorldManager.requestToCreateWorld(dimensionNode);
        TextHelper.sendBroadcastByKey("world.dimension.created", dimensionIdentifier);
        return 1;
    }

    @CommandNode(value="delete")
    private static int $delete(@CommandSource CommandContext<class_2168> ctx, Dimension dimension) {
        class_3218 world = (class_3218)dimension.getValue();
        String identifier = RegistryHelper.ofString((class_1937)world);
        WorldInitializer.checkBlacklist(ctx, identifier);
        WorldManager.requestToDeleteWorld(world);
        Optional<DimensionNode> first = WorldInitializer.storage.model().dimension_list.stream().filter(o -> o.getDimension().equals(identifier)).findFirst();
        if (first.isEmpty()) {
            TextHelper.sendMessageByKey(ctx.getSource(), "world.dimension.not_found", identifier);
            return -1;
        }
        WorldInitializer.storage.model().dimension_list.remove(first.get());
        storage.writeStorage();
        TextHelper.sendBroadcastByKey("world.dimension.deleted", identifier);
        return 1;
    }

    @CommandNode(value="reset")
    @Document(value="Delete and create the specified world.")
    private static int $reset(@CommandSource CommandContext<class_2168> ctx, Optional<Boolean> useTheSameSeed, Dimension dimension) {
        class_3218 world = (class_3218)dimension.getValue();
        String identifier = RegistryHelper.ofString((class_1937)world);
        WorldInitializer.checkBlacklist(ctx, identifier);
        Optional<DimensionNode> dimensionEntryOpt = WorldInitializer.storage.model().dimension_list.stream().filter(o -> o.getDimension().equals(identifier)).findFirst();
        if (dimensionEntryOpt.isEmpty()) {
            TextHelper.sendMessageByKey(ctx.getSource(), "world.dimension.not_found", new Object[0]);
            return -1;
        }
        WorldManager.requestToDeleteWorld(world);
        Boolean $useTheSameSeed = useTheSameSeed.orElse(false);
        long newSeed = $useTheSameSeed != false ? dimensionEntryOpt.get().getSeed() : class_6673.method_39001();
        dimensionEntryOpt.get().setSeed(newSeed);
        storage.writeStorage();
        WorldManager.requestToCreateWorld(dimensionEntryOpt.get());
        TextHelper.sendBroadcastByKey("world.dimension.reset", identifier);
        return 1;
    }

    @Override
    protected void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(this::loadWorlds);
    }

    private void loadWorlds(@NotNull MinecraftServer server) {
        WorldInitializer.storage.model().dimension_list.stream().filter(DimensionNode::isEnable).forEach(it -> {
            try {
                WorldManager.requestToCreateWorld(it);
                LogUtil.info("load dimension {} into the server done.", it.getDimension());
            }
            catch (Exception e) {
                LogUtil.error("failed to load dimension `{}`", it, e);
            }
        });
    }
}

