/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.world_downloader;

import com.google.common.collect.EvictingQueue;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.IOUtil;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.world_downloader.config.model.WorldDownloaderConfigModel;
import io.github.sakurawald.module.initializer.world_downloader.structure.FileDownloadHandler;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class WorldDownloaderInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<WorldDownloaderConfigModel> config = new ObjectConfigurationHandler<WorldDownloaderConfigModel>("config.json", WorldDownloaderConfigModel.class);
    private static EvictingQueue<String> contextQueue;
    private static HttpServer server;

    private static void initServer() {
        if (server != null) {
            server.stop(0);
        }
        try {
            server = HttpServer.create(new InetSocketAddress(WorldDownloaderInitializer.config.model().port), 0);
            server.start();
        }
        catch (IOException e) {
            LogUtil.error("failed to start http server: {}", e.getMessage());
        }
    }

    private static void safelyRemoveContext(String path) {
        try {
            server.removeContext(path);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void safelyRemoveContext(@NotNull HttpContext httpContext) {
        WorldDownloaderInitializer.safelyRemoveContext(httpContext.getPath());
    }

    @CommandNode(value="download")
    @Document(value="Download the region file around you.")
    private static int $download(@CommandSource class_3222 player) {
        if (server == null) {
            WorldDownloaderInitializer.initServer();
        }
        if (contextQueue.remainingCapacity() == 0) {
            LogUtil.debug("contexts is full, remove the oldest context. {}", contextQueue.peek());
            WorldDownloaderInitializer.safelyRemoveContext((String)contextQueue.poll());
        }
        String url = WorldDownloaderInitializer.config.model().url_format;
        int port = WorldDownloaderInitializer.config.model().port;
        url = url.replace("%port%", String.valueOf(port));
        String path = "/world-download/" + String.valueOf(UUID.randomUUID());
        url = url.replace("%path%", path);
        contextQueue.add((Object)path);
        File file = WorldDownloaderInitializer.compressRegionFile(player);
        double BYTE_TO_MEGABYTE = 1048576.0;
        TextHelper.sendBroadcastByKey("world_downloader.request", player.method_7334().getName(), (double)file.length() / BYTE_TO_MEGABYTE);
        server.createContext(path, new FileDownloadHandler(file, WorldDownloaderInitializer.config.model().bytes_per_second_limit));
        TextHelper.sendMessageByKey(player, "world_downloader.response", url);
        return 1;
    }

    @NotNull
    public static File compressRegionFile(@NotNull class_3222 player) {
        File output;
        class_1923 chunkPos = player.method_31476();
        int regionX = chunkPos.method_17885();
        int regionZ = chunkPos.method_17886();
        class_3218 world = player.method_51469();
        MinecraftServer server = world.method_8503();
        class_5321 dimensionKey = world.method_27983();
        class_32.class_5143 session = server.field_23784;
        final File worldDirectory = session.method_27424(dimensionKey).toFile();
        final String regionName = "r." + regionX + "." + regionZ + ".mca";
        ArrayList<File> input = new ArrayList<File>(){
            {
                this.add(new File(worldDirectory, "region" + File.separator + regionName));
                this.add(new File(worldDirectory, "poi" + File.separator + regionName));
                this.add(new File(worldDirectory, "entities" + File.separator + regionName));
            }
        };
        try {
            output = Files.createTempFile(regionName + "#", ".zip", new FileAttribute[0]).toFile();
            IOUtil.compressFiles(worldDirectory, (List<File>)input, output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LogUtil.info("generate region file: {}", output.getAbsolutePath());
        return output;
    }

    @Override
    protected void onInitialize() {
        contextQueue = EvictingQueue.create((int)WorldDownloaderInitializer.config.model().context_cache_size);
    }

    @Override
    protected void onReload() {
        WorldDownloaderInitializer.initServer();
    }
}

