/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.mixin.afk;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.authlib.GameProfile;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.executor.CommandExecutor;
import io.github.sakurawald.core.command.structure.ExtendedCommandSource;
import io.github.sakurawald.module.initializer.afk.AfkInitializer;
import io.github.sakurawald.module.initializer.afk.accessor.AfkStateAccessor;
import io.github.sakurawald.module.initializer.afk.config.model.AfkConfigModel;
import java.util.List;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2703;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class}, priority=750)
public abstract class ServerPlayerMixin
extends class_1657
implements AfkStateAccessor {
    @Unique
    private final class_3222 player = (class_3222)this;
    @Unique
    private boolean afk;
    @Unique
    private long inputCounter = 0L;

    public ServerPlayerMixin(class_1937 world, class_2338 blockPos, float f, GameProfile gameProfile) {
        super(world, blockPos, f, gameProfile);
    }

    @ModifyReturnValue(method={"getPlayerListName"}, at={@At(value="RETURN")})
    public class_2561 $getPlayerListName(class_2561 original) {
        if (this.fuji$isAfk()) {
            return TextHelper.getTextByValue(this.player, AfkInitializer.config.model().format, new Object[0]);
        }
        return original;
    }

    @Inject(method={"updateLastActionTime"}, at={@At(value="TAIL")})
    public void $updateLastActionTime(CallbackInfo ci) {
        this.fuji$incrInputCounter();
    }

    @Override
    public void fuji$changeAfk(boolean flag) {
        this.afk = flag;
        ServerHelper.sendPacketToAll(new class_2703(class_2703.class_5893.field_29139, (class_3222)this));
        AfkConfigModel.AfkEvent afkEvent = AfkInitializer.config.model().afk_event;
        List<String> commandList = this.afk ? afkEvent.on_enter_afk : afkEvent.on_leave_afk;
        CommandExecutor.execute(ExtendedCommandSource.asConsole(this.player.method_64396()), commandList);
    }

    @Override
    public boolean fuji$isAfk() {
        return this.afk;
    }

    @Override
    public void fuji$incrInputCounter() {
        ++this.inputCounter;
        if (this.fuji$isAfk()) {
            this.fuji$changeAfk(false);
        }
    }

    @Override
    public long fuji$getInputCounter() {
        return this.inputCounter;
    }

    public void method_5784(class_1313 movementType, class_243 vec3d) {
        if (AfkInitializer.isPlayerActuallyMovedItself(movementType, vec3d)) {
            this.fuji$incrInputCounter();
        }
        super.method_5784(movementType, vec3d);
    }
}

