/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.mixin.chat.mention;

import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.job.impl.MentionPlayersJob;
import io.github.sakurawald.module.initializer.chat.mention.ChatMentionInitializer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_2797;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={class_3244.class}, priority=1750)
public abstract class ServerPlayNetworkHandlerMixin {
    @Unique
    private List<class_3222> resolveMentionedPlayers(String string) {
        String[] playerNames = ServerHelper.getServer().method_3858();
        List<class_3222> list = Arrays.stream(playerNames).filter(string::contains).sorted(Comparator.comparingInt(String::length).reversed()).map(ServerHelper::getPlayerByName).toList();
        if (!list.isEmpty()) {
            MentionPlayersJob.requestJob(ChatMentionInitializer.config.model().mention_player, list);
        }
        return list;
    }

    @Unique
    private String replaceMentionString(@NotNull String string) {
        List<class_3222> mentionedPlayers = this.resolveMentionedPlayers(string);
        for (class_3222 mentionedPlayer : mentionedPlayers) {
            String playerName = mentionedPlayer.method_7334().getName();
            String replacement = ChatMentionInitializer.config.model().mention_format.formatted(playerName);
            string = string.replace(playerName, replacement);
        }
        return string;
    }

    @ModifyVariable(method={"onChatMessage"}, at=@At(value="HEAD"), argsOnly=true)
    public class_2797 modifyChatMessageSentByPlayers(class_2797 original) {
        String oldChatMessage = original.comp_945();
        String newChatMessage = this.replaceMentionString(oldChatMessage);
        return new class_2797(newChatMessage, original.comp_946(), original.comp_947(), original.comp_948(), original.comp_970());
    }
}

