/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.mixin.gameplay.carpet.fake_player_manager;

import carpet.commands.PlayerCommand;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.module.initializer.gameplay.carpet.fake_player_manager.FakePlayerManagerInitializer;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerCommand.class})
public abstract class PlayerCommandMixin {
    @Unique
    @NotNull
    private static String transformFakePlayerName(@NotNull String fakePlayerName) {
        return FakePlayerManagerInitializer.config.model().transform_name.replace("%name%", fakePlayerName);
    }

    @Redirect(method={"cantSpawn"}, at=@At(value="INVOKE", target="Lcom/mojang/brigadier/arguments/StringArgumentType;getString(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/String;)Ljava/lang/String;"), remap=false)
    @NotNull
    private static String $canSpawn(@NotNull CommandContext<?> context, String name) {
        return PlayerCommandMixin.transformFakePlayerName(StringArgumentType.getString(context, (String)name));
    }

    @Redirect(method={"spawn"}, at=@At(value="INVOKE", target="Lcom/mojang/brigadier/arguments/StringArgumentType;getString(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/String;)Ljava/lang/String;"), remap=false)
    @NotNull
    private static String $spawn(@NotNull CommandContext<?> context, String name) {
        return PlayerCommandMixin.transformFakePlayerName(StringArgumentType.getString(context, (String)name));
    }

    @Inject(method={"spawn"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void $spawn_head(@NotNull CommandContext<class_2168> context, @NotNull CallbackInfoReturnable<Integer> cir) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return;
        }
        if (!FakePlayerManagerInitializer.canSpawnFakePlayer(player)) {
            TextHelper.sendMessageByKey(player, "fake_player_manager.spawn.limit_exceed", new Object[0]);
            cir.setReturnValue((Object)-1);
        }
    }

    @Inject(method={"spawn"}, at={@At(value="TAIL")}, remap=false)
    private static void $spawn_tail(@NotNull CommandContext<class_2168> context, CallbackInfoReturnable<Integer> cir) {
        String playerArg = StringArgumentType.getString(context, (String)"player");
        playerArg = PlayerCommandMixin.transformFakePlayerName(playerArg);
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        FakePlayerManagerInitializer.addMyFakePlayer(player, playerArg);
        FakePlayerManagerInitializer.renewMyFakePlayers(player);
    }

    @Inject(method={"cantManipulate"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void $cantManipulate(@NotNull CommandContext<class_2168> context, @NotNull CallbackInfoReturnable<Boolean> cir) {
        String playerArg = StringArgumentType.getString(context, (String)"player");
        if (!FakePlayerManagerInitializer.canManipulateFakePlayer(context, playerArg)) {
            TextHelper.sendMessageByKey(context.getSource(), "fake_player_manager.manipulate.forbidden", new Object[0]);
            cir.setReturnValue((Object)true);
        }
    }
}

