/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.economy.service;

import com.mojang.authlib.GameProfile;
import eu.pb4.common.economy.api.CommonEconomy;
import eu.pb4.common.economy.api.EconomyAccount;
import eu.pb4.common.economy.api.EconomyCurrency;
import eu.pb4.common.economy.api.EconomyProvider;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.minecraft.AuthlibHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.ServerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.argument.wrapper.impl.OfflineGameProfile;
import mod.fuji.core.command.exception.AbortCommandExecutionException;
import mod.fuji.module.initializer.economy.EconomyInitializer;
import mod.fuji.module.initializer.economy.config.structure.CustomEconomyAccountNode;
import mod.fuji.module.initializer.economy.config.structure.CustomEconomyCurrencyNode;
import mod.fuji.module.initializer.economy.structure.CustomEconomyCurrency;
import mod.fuji.module.initializer.economy.structure.CustomEconomyProvider;
import mod.fuji.module.initializer.economy.structure.GameProfileAndEconomyAccount;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class EconomyService {
    @NotNull
    public static Collection<EconomyCurrency> getServerCurrencies() {
        MinecraftServer server = ServerHelper.getServer();
        return CommonEconomy.getCurrencies((MinecraftServer)server);
    }

    @NotNull
    public static Collection<class_2960> getServerCurrencyIds() {
        return EconomyService.getServerCurrencies().stream().map(EconomyCurrency::id).toList();
    }

    public static boolean isCurrencyInstalledOnThisServer(@NotNull class_2960 currencyId) {
        return EconomyService.getServerCurrencyIds().stream().anyMatch(it -> it.equals((Object)currencyId));
    }

    @NotNull
    public static Collection<EconomyProvider> getProviders() {
        return CommonEconomy.providers();
    }

    @NotNull
    public static Collection<EconomyAccount> getUserAccounts(@NotNull GameProfile gameProfile) {
        MinecraftServer server = ServerHelper.getServer();
        return CommonEconomy.getAccounts((MinecraftServer)server, (GameProfile)gameProfile);
    }

    @NotNull
    public static Optional<EconomyAccount> getUserAccount(@NotNull GameProfile gameProfile, @NotNull class_2960 currencyId) {
        return EconomyService.getUserAccounts(gameProfile).stream().filter(account -> {
            class_2960 id = account.currency().id();
            return id.equals((Object)currencyId);
        }).findFirst();
    }

    @NotNull
    private static <T> T withCustomEconomyCurrencyNode(@NotNull class_2960 currencyId, @NotNull Function<CustomEconomyCurrencyNode, T> function) {
        Optional<CustomEconomyCurrencyNode> customEconomyCurrencyNode = EconomyInitializer.data.model().currencies.stream().filter(currency -> currency.currencyId.equals(currencyId.toString())).findFirst();
        CustomEconomyCurrencyNode $customEconomyCurrencyNode = customEconomyCurrencyNode.orElseGet(() -> {
            if (EconomyService.isCurrencyInstalledOnThisServer(currencyId)) {
                CustomEconomyCurrencyNode newValue = CustomEconomyCurrencyNode.make(currencyId.toString());
                EconomyInitializer.data.model().currencies.add(newValue);
                EconomyInitializer.data.writeStorage();
                return newValue;
            }
            throw new IllegalArgumentException("The currency %s didn't installed in the server.".formatted(currencyId));
        });
        return function.apply($customEconomyCurrencyNode);
    }

    @NotNull
    public static CustomEconomyAccountNode getCustomAccountNode(@NotNull GameProfile gameProfile, @NotNull class_2960 currencyId) {
        return EconomyService.withCustomEconomyCurrencyNode(currencyId, customEconomyCurrencyNode -> {
            Optional<CustomEconomyAccountNode> customEconomyAccountNode = customEconomyCurrencyNode.accounts.stream().filter(it -> it.ownerName.equals(AuthlibHelper.getName(gameProfile))).findFirst();
            CustomEconomyAccountNode $customEconomyAccountNode = customEconomyAccountNode.orElseGet(() -> {
                CustomEconomyCurrency customEconomyCurrency = CustomEconomyProvider.getCustomEconomyCurrency(currencyId);
                long defaultBalance = (long)(customEconomyCurrency.currencyDescriptor.defaultFaceBalance * 100.0);
                CustomEconomyAccountNode newValue = CustomEconomyAccountNode.make(gameProfile, defaultBalance);
                customEconomyCurrencyNode.accounts.add(newValue);
                EconomyInitializer.data.writeStorage();
                return newValue;
            });
            return $customEconomyAccountNode;
        });
    }

    public static void transferCurrency(@NotNull class_3222 source, @NotNull OfflineGameProfile player, @NotNull class_2960 currencyId, double amount) {
        long deltaValue = (long)(amount * 100.0);
        deltaValue = Math.max(0L, deltaValue);
        EconomyAccount fromAccount = EconomyService.tryGetEconomyAccount(source.method_5671(), source.method_7334(), currencyId);
        EconomyAccount toAccount = EconomyService.tryGetEconomyAccount(source.method_5671(), (GameProfile)player.getValue(), currencyId);
        long fromAccountPreviousBalance = fromAccount.balance();
        long toAccountPreviousBalance = toAccount.balance();
        if (fromAccount.canDecreaseBalance(deltaValue).isSuccessful() && toAccount.canIncreaseBalance(deltaValue).isSuccessful()) {
            try {
                fromAccount.decreaseBalance(deltaValue);
                toAccount.increaseBalance(deltaValue);
                TextHelper.sendTextByKey(source, "operation.success", new Object[0]);
            }
            catch (Exception rollbackIfFailed) {
                LogUtil.error("Failed to transfer currency {} with amount {} from account {} to account {}", currencyId, amount, fromAccount, toAccount, rollbackIfFailed);
                fromAccount.setBalance(fromAccountPreviousBalance);
                toAccount.setBalance(toAccountPreviousBalance);
                TextHelper.sendTextByKey(source, "operation.fail", new Object[0]);
            }
        } else {
            TextHelper.sendTextByKey(source, "operation.fail", new Object[0]);
        }
    }

    public static int getBalanceTopPageSize() {
        return EconomyInitializer.config.model().getBalanceTopPageSize();
    }

    @NotNull
    public static List<GameProfileAndEconomyAccount> makeBalanceTopEntities(@NotNull class_3222 player, @NotNull class_2960 currencyId) {
        return PlayerHelper.Cache.getOfflineGameProfiles().stream().map(gameProfile -> {
            EconomyAccount economyAccount = EconomyService.tryGetEconomyAccount(player.method_5671(), gameProfile, currencyId);
            return new GameProfileAndEconomyAccount((GameProfile)gameProfile, economyAccount);
        }).sorted(Comparator.comparing(GameProfileAndEconomyAccount::getEconomyBalance).reversed()).toList();
    }

    @NotNull
    public static EconomyAccount tryGetEconomyAccount(@NotNull class_2168 source, @NotNull GameProfile gameProfile, @NotNull class_2960 currencyId) {
        Optional<EconomyAccount> economyAccount = EconomyService.getUserAccount(gameProfile, currencyId);
        if (economyAccount.isEmpty()) {
            TextHelper.sendTextByKey(source, "economy.account.not_found", AuthlibHelper.getName(gameProfile), currencyId);
            throw new AbortCommandExecutionException();
        }
        return economyAccount.get();
    }
}

