/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.predicate;

import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import mod.fuji.core.auxiliary.minecraft.AuthlibHelper;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.EntityHelper;
import mod.fuji.core.auxiliary.minecraft.InventoryHelper;
import mod.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import mod.fuji.core.auxiliary.minecraft.PlaceholderHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandRequirement;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.command.argument.wrapper.impl.Dimension;
import mod.fuji.core.command.argument.wrapper.impl.GreedyString;
import mod.fuji.core.command.argument.wrapper.impl.OfflineGameProfile;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.ColorBoxes;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.document.descriptor.PermissionDescriptor;
import mod.fuji.module.initializer.ModuleInitializer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2168;
import net.minecraft.class_2293;
import net.minecraft.class_3222;

@Document(id=1751826497994L, value="This module provides a collection of `predicate commands`.\nThey can be used to test the `conditions`.\n")
@ColorBoxes(value={@ColorBox(id=1751978705157L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 How it works?\nA `predicate command` will return an `integer value` to represent the `SUCCESS` or `FAILED` test result.\nIt relies on the `return value of command` in vanilla Minecraft.\nSee https://minecraft.fandom.com/wiki/Commands/return\n\nActually, you can also use the `predicate command` with `command block`.\n"), @ColorBox(id=1751978789271L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Test a condition, and then run a command if success.\nIssue: `/run as player Alice chain has-perm? %player:name% 4 chain say value is true`\n"), @ColorBox(id=1754448424606L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Test if a player is holding an apple\nIssue: `/command-debug is-holding? Steve minecraft:apple`\n\n\u25c9 Test if a player has specified string permission\nIssue: `/command-debug has-perm? Steve fuji.permission.back`\n\n\u25c9 Test if a player's health >= 10\nIssue: `/command-debug <=? Steve 10 %player:health%`\n\n\u25c9 Test if a player killed more than 100 zombies.\nIssue: `/command-debug <=? Steve 100 %player:statistic_raw minecraft:deaths%`\n\n\u25c9 Leverage the `vanilla Minecraft statistics`\nSee: https://minecraft.fandom.com/wiki/Statistics\n\n\u25c9 More examples\nYou can see more examples in `command_meta.IF` module and `command_meta.chain` module.\n")})
@CommandRequirement(level=4)
public class PredicateInitializer
extends ModuleInitializer {
    @CommandNode(value="has-perm?")
    private static int $hasPerm(@CommandSource class_2168 source, OfflineGameProfile player, GreedyString stringPermission) {
        GameProfile gameProfile = (GameProfile)player.getValue();
        boolean value = LuckpermsHelper.hasPermission(AuthlibHelper.getId(gameProfile), new PermissionDescriptor(true, (String)stringPermission.getValue(), 0L), new Object[0]);
        return CommandHelper.Return.returnBoolean(source, value);
    }

    @Document(id=1751826502598L, value="Predicate to test if the player has the level-perm?")
    @CommandNode(value="has-level?")
    private static int $hasLevel(@CommandSource class_2168 source, OfflineGameProfile player, int levelPermission) {
        GameProfile gameProfile = (GameProfile)player.getValue();
        boolean value = CommandHelper.Requirement.getPermissionLevel(gameProfile) >= levelPermission;
        return CommandHelper.Return.returnBoolean(source, value);
    }

    @Document(id=1751826504480L, value="Predicate if online players >= n.")
    @CommandNode(value="has-players?")
    private static int $hasPlayers(@CommandSource class_2168 source, Optional<Integer> n) {
        int $n = n.orElse(0);
        boolean value = PlayerHelper.Lookup.getOnlinePlayers().size() >= $n;
        return CommandHelper.Return.returnBoolean(source, value);
    }

    @CommandNode(value="is-op?")
    private static int $isOp(@CommandSource class_2168 source, class_3222 player) {
        boolean value = CommandHelper.Requirement.isOperator((class_1657)player);
        return CommandHelper.Return.returnBoolean(source, value);
    }

    @CommandNode(value="is-holding?")
    private static int $isHolding(@CommandSource class_2168 source, class_3222 player, class_2293.class_2295 itemPredicate) {
        boolean value = player.method_24520((Predicate)itemPredicate);
        return CommandHelper.Return.returnBoolean(source, value);
    }

    @CommandNode(value="has-item?")
    private static int $hasItem(@CommandSource class_2168 source, class_3222 player, class_2293.class_2295 itemPredicate, int count) {
        int matchCount = 0;
        for (class_1799 inventoryStack : InventoryHelper.getInventoryStacks((class_1657)player)) {
            boolean test = itemPredicate.test((Object)inventoryStack);
            if (!test) continue;
            matchCount += inventoryStack.method_7947();
        }
        boolean success = matchCount >= count;
        return CommandHelper.Return.returnBoolean(source, success);
    }

    @CommandNode(value="has-exp?")
    private static int $hasExp(@CommandSource class_2168 source, class_3222 player, int exp) {
        boolean value = player.field_7495 >= exp;
        return CommandHelper.Return.returnBoolean(source, value);
    }

    @CommandNode(value="has-exp-level?")
    private static int $hasExpLevel(@CommandSource class_2168 source, class_3222 player, int expLevel) {
        boolean value = player.field_7520 >= expLevel;
        return CommandHelper.Return.returnBoolean(source, value);
    }

    @CommandNode(value="is-in-world?")
    private static int $isInWorld(@CommandSource class_2168 source, class_3222 player, Dimension dimension) {
        boolean value = EntityHelper.getServerWorld((class_1297)player).equals(dimension.getValue());
        return CommandHelper.Return.returnBoolean(source, value);
    }

    @CommandNode(value="is-in-gamemode?")
    private static int $isInGameMode(@CommandSource class_2168 source, class_3222 player, class_1934 gameMode) {
        boolean value = player.field_13974.method_14257().equals((Object)gameMode);
        return CommandHelper.Return.returnBoolean(source, value);
    }

    @CommandNode(value="=?")
    private static int $equalsNumber(@CommandSource class_2168 source, class_3222 player, double value, GreedyString numericValueString) {
        return PredicateInitializer.compareNumericValue(source, player, value, numericValueString, Objects::equals);
    }

    @CommandNode(value="!=?")
    private static int $notEqualsNumber(@CommandSource class_2168 source, class_3222 player, double value, GreedyString numericValueString) {
        return PredicateInitializer.compareNumericValue(source, player, value, numericValueString, (a, b) -> !Objects.equals(a, b));
    }

    @CommandNode(value=">?")
    private static int $greaterThanNumber(@CommandSource class_2168 source, class_3222 player, double value, GreedyString numericValueString) {
        return PredicateInitializer.compareNumericValue(source, player, value, numericValueString, (a, b) -> a > b);
    }

    @CommandNode(value=">=?")
    private static int $greaterEqualsThanNumber(@CommandSource class_2168 source, class_3222 player, double value, GreedyString numericValueString) {
        return PredicateInitializer.compareNumericValue(source, player, value, numericValueString, (a, b) -> a >= b);
    }

    @CommandNode(value="<?")
    private static int $lessThanNumber(@CommandSource class_2168 source, class_3222 player, double value, GreedyString numericValueString) {
        return PredicateInitializer.compareNumericValue(source, player, value, numericValueString, (a, b) -> a < b);
    }

    @CommandNode(value="<=?")
    private static int $lessEqualsThanNumber(@CommandSource class_2168 source, class_3222 player, double value, GreedyString numericValueString) {
        return PredicateInitializer.compareNumericValue(source, player, value, numericValueString, (a, b) -> a <= b);
    }

    private static int compareNumericValue(class_2168 source, class_3222 player, double value, GreedyString placeholderString, BiPredicate<Double, Double> predicate) {
        String numericValueString = PlaceholderHelper.parsePlaceholderString(player, (String)placeholderString.getValue());
        try {
            double numericValue = Double.parseDouble(numericValueString);
            boolean testResult = predicate.test(value, numericValue);
            return CommandHelper.Return.returnBoolean(source, testResult);
        }
        catch (NumberFormatException e) {
            TextHelper.sendTextByKey(source, "placeholder.number.parse.failed", TextHelper.Parsers.escapeTags(numericValueString));
            return 0;
        }
    }

    @CommandNode(value="equals?")
    private static int $equals(@CommandSource class_2168 source, class_3222 player, String expectedString, GreedyString placeholderString) {
        return PredicateInitializer.compareStringValue(source, player, expectedString, placeholderString, String::equals);
    }

    @CommandNode(value="true?")
    private static int $true(@CommandSource class_2168 source, class_3222 player, GreedyString placeholderString) {
        return PredicateInitializer.$equals(source, player, "true", placeholderString);
    }

    @CommandNode(value="false?")
    private static int $false(@CommandSource class_2168 source, class_3222 player, GreedyString placeholderString) {
        return PredicateInitializer.$equals(source, player, "false", placeholderString);
    }

    @CommandNode(value="matches?")
    private static int $matches(@CommandSource class_2168 source, class_3222 player, String expectedString, GreedyString placeholderString) {
        return PredicateInitializer.compareStringValue(source, player, expectedString, placeholderString, (a, b) -> b.matches((String)a));
    }

    private static int compareStringValue(class_2168 source, class_3222 player, String value, GreedyString placeholderString, BiPredicate<String, String> predicate) {
        String placeholderValue = PlaceholderHelper.parsePlaceholderString(player, (String)placeholderString.getValue());
        boolean test = predicate.test(value, placeholderValue);
        return CommandHelper.Return.returnBoolean(source, test);
    }
}

