/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.service.gameprofile_fetcher;

import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import mod.fuji.core.auxiliary.HttpUtil;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.minecraft.AuthlibHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.service.gameprofile_fetcher.MojangSkinProvider;
import org.jetbrains.annotations.NotNull;

public class MojangProfileFetcher {
    private static final String API_SERVER = "https://api.mojang.com/users/profiles/minecraft/";
    private static final Pattern UUID_CONVERTER_PATTERN = Pattern.compile("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)");

    public static Optional<GameProfile> fetchOnlineGameProfile(@NotNull String playerName) {
        return MojangProfileFetcher.fetchOnlinePlayerUUID(playerName).map(uuid -> new GameProfile(uuid, playerName)).map(gameProfile -> {
            MojangSkinProvider.fetchSkin(playerName).ifPresent(property -> AuthlibHelper.modifyGameProfile(gameProfile, property));
            return gameProfile;
        });
    }

    public static Optional<UUID> fetchOnlinePlayerUUID(@NotNull String playerName) {
        return PlayerHelper.Cache.getUserCache().map($userCache -> {
            try {
                return PlayerHelper.Cache.getOfflineGameProfileByName(playerName).map(AuthlibHelper::getId).or(() -> MojangProfileFetcher.fetchOnlinePlayerUUID$Fallback(playerName));
            }
            catch (Exception e) {
                return MojangProfileFetcher.fetchOnlinePlayerUUID$Fallback(playerName);
            }
        }).orElseGet(() -> MojangProfileFetcher.fetchOnlinePlayerUUID$Fallback(playerName));
    }

    private static Optional<UUID> fetchOnlinePlayerUUID$Fallback(@NotNull String playerName) {
        String rawUUID;
        try {
            String json = HttpUtil.sendGetRequest(API_SERVER + playerName);
            rawUUID = JsonParser.parseString((String)json).getAsJsonObject().get("id").getAsString();
        }
        catch (IOException e) {
            LogUtil.debug("Failed to fetch online uuid from mojang server for {}", playerName);
            return Optional.empty();
        }
        UUID value = UUID.fromString(UUID_CONVERTER_PATTERN.matcher(rawUUID).replaceFirst("$1-$2-$3-$4-$5"));
        return Optional.of(value);
    }
}

