/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.fuji.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import mod.fuji.core.auxiliary.minecraft.RegistryHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.gui.component.gui.PagedGui;
import mod.fuji.module.initializer.fuji.structure.IdentifierDescriptor;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7655;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistriesInspectionGui
extends PagedGui<IdentifierDescriptor> {
    private final boolean isMetaRegistry;

    public RegistriesInspectionGui(@Nullable SimpleGui parent, class_3222 player, boolean isMetaRegistry, @NotNull List<IdentifierDescriptor> entities, int pageIndex) {
        super(parent, player, TextHelper.getTextByKey(player, "registry.list.gui.title", new Object[0]), entities, pageIndex);
        this.isMetaRegistry = isMetaRegistry;
    }

    public static RegistriesInspectionGui inspectAll(class_3222 player) {
        List<class_2960> staticRegistries = class_7923.field_41167.method_42021().stream().map(class_5321::method_29177).toList();
        List<class_2960> dynamicRegistries = class_7655.field_39968.stream().map(it -> it.comp_985().method_29177()).toList();
        ArrayList<IdentifierDescriptor> ids = new ArrayList<IdentifierDescriptor>();
        staticRegistries.forEach(id -> ids.add(new IdentifierDescriptor((class_2960)id, false)));
        dynamicRegistries.forEach(id -> ids.add(new IdentifierDescriptor((class_2960)id, true)));
        ids.sort(Comparator.comparing(IdentifierDescriptor::getIdentifier));
        return new RegistriesInspectionGui(null, player, true, ids, 0);
    }

    @Override
    protected PagedGui<IdentifierDescriptor> makePage(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2561 title, @NotNull List<IdentifierDescriptor> entities, int pageIndex) {
        return new RegistriesInspectionGui(parent, player, this.isMetaRegistry, entities, pageIndex);
    }

    @Override
    @NotNull
    protected GuiElementInterface toGuiElement(@NotNull IdentifierDescriptor entity) {
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        lore.add(TextHelper.getTextByKey(this.getPlayer(), "registry.type.is_dynamic", entity.isDynamic()));
        if (this.isMetaRegistry) {
            lore.add(TextHelper.getTextByKey(this.getPlayer(), "prompt.click.see_inside", new Object[0]));
        }
        GuiElementBuilder guiElementBuilder = (GuiElementBuilder)new GuiElementBuilder().setName(class_2561.method_30163((String)entity.getIdentifier().toString())).setItem(this.getItem(entity)).setLore(lore).setCallback(this.openRegistry(entity));
        if (entity.isDynamic()) {
            guiElementBuilder.glow();
        }
        return guiElementBuilder.build();
    }

    private class_1792 getItem(IdentifierDescriptor entity) {
        if (!this.isMetaRegistry) {
            return class_1802.field_8407;
        }
        return entity.isDynamic() ? class_1802.field_8674 : class_1802.field_8529;
    }

    @NotNull
    private Runnable openRegistry(IdentifierDescriptor entity) {
        return () -> {
            if (!this.isMetaRegistry) {
                return;
            }
            Object o = class_7923.field_41167.method_10223(entity.getIdentifier());
            if (o instanceof class_2378) {
                class_2378 r = (class_2378)o;
                List<IdentifierDescriptor> ids = r.method_42021().stream().map(class_5321::method_29177).sorted().map(identifier -> new IdentifierDescriptor((class_2960)identifier, false)).toList();
                new RegistriesInspectionGui(this.getBackendGui(), this.getPlayer(), false, ids, 0).open();
                return;
            }
            Optional<class_7655.class_7657> first = class_7655.field_39968.stream().filter(it -> RegistryHelper.getIdAsString(it.comp_985()).equals(entity.getIdentifier().toString())).findFirst();
            if (first.isPresent()) {
                List<IdentifierDescriptor> ids = RegistryHelper.getRegistry(first.get().comp_985()).method_10235().stream().sorted().map(identifier -> new IdentifierDescriptor((class_2960)identifier, true)).toList();
                new RegistriesInspectionGui(this.getBackendGui(), this.getPlayer(), false, ids, 0).open();
                return;
            }
        };
    }
}

