/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.auxiliary;

import java.text.SimpleDateFormat;
import org.jetbrains.annotations.NotNull;

public final class ChronosUtil {
    private static final SimpleDateFormat STANDARD_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");

    @NotNull
    public static String getCurrentDate() {
        return ChronosUtil.getCurrentDate(STANDARD_DATE_FORMAT);
    }

    @NotNull
    public static String getCurrentDate(SimpleDateFormat formatter) {
        return formatter.format(System.currentTimeMillis());
    }

    @NotNull
    public static String toStandardDateFormat(long timeMillis) {
        return STANDARD_DATE_FORMAT.format(timeMillis);
    }

    @NotNull
    public static Long getCurrentMillis() {
        return System.currentTimeMillis();
    }

    private ChronosUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

