/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.auxiliary;

import io.github.sakurawald.core.config.Configs;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.jetbrains.annotations.NotNull;

public final class LogUtil {
    @NotNull
    private static final Logger MOD_LOGGER = LogUtil.makeLogger(StringUtils.capitalize((String)"fuji"));
    private static final boolean isConsoleSupportAnsiColor = LogUtil.isConsoleSupportAnsiColor();

    @NotNull
    private static Logger makeLogger(String name) {
        Logger logger = LogManager.getLogger((String)name);
        try {
            String level = System.getProperty("%s.level".formatted("fuji"));
            Configurator.setLevel((Logger)logger, (Level)Level.getLevel((String)level));
        }
        catch (Exception e) {
            return logger;
        }
        return logger;
    }

    private static boolean isConsoleSupportAnsiColor() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
    }

    public static void debug(String message, Object ... args) {
        if (Configs.configHandler.model().core.debug.log_debug_messages || FabricLoader.getInstance().isDevelopmentEnvironment()) {
            String prefix = isConsoleSupportAnsiColor ? "\u001b[37m" : "";
            String format = prefix + message;
            MOD_LOGGER.info(format, args);
        } else {
            MOD_LOGGER.debug(message, args);
        }
    }

    public static void info(String message, Object ... args) {
        MOD_LOGGER.info(message, args);
    }

    public static void warn(String message, Object ... args) {
        MOD_LOGGER.warn(message, args);
    }

    public static void error(String message, Object ... args) {
        MOD_LOGGER.error(message, args);
    }

    public static List<String> getStackTraceAsList(Throwable throwable) {
        return Arrays.stream(throwable.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.toList());
    }

    private LogUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

