/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.auxiliary.minecraft;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import io.github.sakurawald.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;

public final class CommandHelper {
    public static final String UUID = "uuid";
    public static final int EXCEPTION_COLOR = 0xFF5F00;

    @NotNull
    public static String computeCommandNodePath(CommandNode<class_2168> node) {
        CommandDispatcher<class_2168> dispatcher = ServerHelper.getCommandDispatcher();
        assert (dispatcher != null);
        CharSequence[] array = dispatcher.getPath(node).toArray(new String[0]);
        return String.join((CharSequence)".", array);
    }

    public static void updateCommandTree() {
        class_2170 commandManager = ServerHelper.getServer().method_3734();
        ServerHelper.getPlayers().forEach(arg_0 -> ((class_2170)commandManager).method_9241(arg_0));
    }

    public static List<CommandNode<class_2168>> getCommandNodes() {
        ArrayList<CommandNode<class_2168>> ret = new ArrayList<CommandNode<class_2168>>();
        RootCommandNode root = Objects.requireNonNull(ServerHelper.getCommandDispatcher()).getRoot();
        CommandHelper.getCommandNodes(ret, (CommandNode<class_2168>)root);
        return ret;
    }

    private static void getCommandNodes(List<CommandNode<class_2168>> collector, CommandNode<class_2168> parent) {
        parent.getChildren().forEach(it -> CommandHelper.getCommandNodes(collector, (CommandNode<class_2168>)it));
        if (!parent.getName().isEmpty()) {
            collector.add(parent);
        }
    }

    private CommandHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class Pattern {
        public static int playerOnlyCommand(@NotNull CommandContext<class_2168> ctx, @NotNull Function<class_3222, Integer> function) {
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            if (player == null) {
                TextHelper.sendMessageByKey(ctx.getSource(), "command.player_only", new Object[0]);
                return 1;
            }
            return function.apply(player);
        }

        public static int itemInHandCommand(@NotNull CommandContext<class_2168> ctx, @NotNull BiFunction<class_3222, class_1799, Integer> consumer) {
            return Pattern.playerOnlyCommand(ctx, player -> {
                class_1799 mainHandStack = player.method_6047();
                if (mainHandStack.method_7960()) {
                    TextHelper.sendMessageByKey(player, "item.empty.not_allow", new Object[0]);
                    return -1;
                }
                return (Integer)consumer.apply((class_3222)player, mainHandStack);
            });
        }
    }

    public static class Suggestion {
        @NotNull
        public static <T> SuggestionProvider<class_2168> enums(Supplier<T[]> enumSupplier) {
            return (context, builder) -> {
                for (Object value : (Object[])enumSupplier.get()) {
                    builder.suggest(value.toString());
                }
                return builder.buildFuture();
            };
        }

        @NotNull
        public static <T> SuggestionProvider<class_2168> iterable(Supplier<Iterable<T>> iterableSupplier) {
            return (context, builder) -> {
                for (Object value : (Iterable)iterableSupplier.get()) {
                    builder.suggest(value.toString());
                }
                return builder.buildFuture();
            };
        }

        @NotNull
        public static <T> SuggestionProvider<class_2168> identifiers(class_5321<? extends class_2378<T>> registryKey) {
            return Suggestion.iterable(() -> RegistryHelper.ofRegistry(registryKey).method_10235());
        }
    }

    public static class Return {
        public static final int FAIL = -1;
        public static final int PASS = 0;
        public static final int SUCCESS = 1;

        private static int fromBoolean(boolean value) {
            return value ? 1 : -1;
        }

        public static int outputBoolean(class_2168 source, boolean value) {
            if (source.method_43737()) {
                source.method_45068((class_2561)class_2561.method_43470((String)String.valueOf(value)));
            }
            return Return.fromBoolean(value);
        }
    }
}

