/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.auxiliary.minecraft;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.context.CommandContext;
import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.node.LiteralNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.api.parsers.tag.TagRegistry;
import eu.pb4.placeholders.api.parsers.tag.TextTag;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.config.Configs;
import io.github.sakurawald.core.config.handler.impl.ResourceConfigurationHandler;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextHelper {
    public static final class_2561 TEXT_NEWLINE = class_2561.method_30163((String)"\n");
    public static final class_2561 TEXT_SPACE = class_2561.method_30163((String)" ");
    private static final NodeParser POWERFUL_PARSER = NodeParser.builder().quickText().simplifiedTextFormat().globalPlaceholders().markdown().build();
    private static final NodeParser PLACEHOLDER_PARSER = NodeParser.builder().globalPlaceholders().build();
    private static final Map<String, String> player2code = new HashMap<String, String>();
    private static final Map<String, JsonObject> code2json = new HashMap<String, JsonObject>();
    private static final JsonObject UNSUPPORTED_LANGUAGE_MARKER = new JsonObject();
    private static final String SUPPRESS_SENDING_STRING_MARKER = "[suppress-sending]";
    private static final class_2561 SUPPRESS_SENDING_TEXT_MARKER = class_2561.method_43470((String)"[suppress-sending]");

    private static void writeDefaultLanguageFilesIfAbsent() {
        for (String languageFile : ReflectionUtil.getGraph("language-graph.txt")) {
            new ResourceConfigurationHandler("lang/" + languageFile).readStorage();
        }
    }

    public static void clearLoadedLanguageJsons() {
        code2json.clear();
    }

    public static void setClientSideLanguageCode(String playerName, String languageRepresentationUsedByMojang) {
        player2code.put(playerName, TextHelper.convertToLanguageCode(languageRepresentationUsedByMojang));
    }

    private static void loadLanguageJsonIfAbsent(String languageCode) {
        if (code2json.containsKey(languageCode)) {
            return;
        }
        try {
            String languageFile = languageCode + ".json";
            ResourceConfigurationHandler resourceConfigurationHandler = new ResourceConfigurationHandler("lang/" + languageFile);
            resourceConfigurationHandler.readStorage();
            code2json.put(languageCode, ((JsonElement)resourceConfigurationHandler.model()).getAsJsonObject());
            LogUtil.info("language {} loaded.", languageCode);
        }
        catch (Exception e) {
            code2json.put(languageCode, UNSUPPORTED_LANGUAGE_MARKER);
            LogUtil.warn("failed to load language `{}`", languageCode);
        }
    }

    private static String convertToLanguageCode(String input) {
        if (input == null || !input.contains("_")) {
            return input;
        }
        String[] parts = input.split("_");
        String language = parts[0].toLowerCase();
        String region = parts[1].toUpperCase();
        return language + "_" + region;
    }

    @NotNull
    private static String getClientSideLanguageCode(@Nullable Object audience) {
        class_3222 class_32222;
        if (audience == null) {
            return TextHelper.getDefaultLanguageCode();
        }
        Object object = audience;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_3222.class, class_1657.class, class_2168.class}, (Object)object2, n)) {
                case 0: {
                    class_3222 serverPlayerEntity;
                    class_32222 = serverPlayerEntity = (class_3222)object2;
                    break block5;
                }
                case 1: {
                    class_1657 playerEntity = (class_1657)object2;
                    class_32222 = playerEntity;
                    break block5;
                }
                case 2: {
                    class_2168 source = (class_2168)object2;
                    if (source.method_44023() == null) {
                        n = 3;
                        continue block5;
                    }
                    class_32222 = source.method_44023();
                    break block5;
                }
                default: {
                    class_32222 = null;
                    break block5;
                }
            }
            break;
        }
        class_3222 player = class_32222;
        if (player == null) {
            return TextHelper.getDefaultLanguageCode();
        }
        return player2code.getOrDefault(player.method_7334().getName(), TextHelper.getDefaultLanguageCode());
    }

    @NotNull
    private static JsonObject getLanguageJsonObject(String languageCode) {
        TextHelper.loadLanguageJsonIfAbsent(languageCode);
        return code2json.get(languageCode);
    }

    private static String getDefaultLanguageCode() {
        return TextHelper.convertToLanguageCode(Configs.configHandler.model().core.language.default_language);
    }

    private static boolean isDefaultLanguageCode(String languageCode) {
        return languageCode.equals(TextHelper.getDefaultLanguageCode());
    }

    @NotNull
    public static String getValueByKey(@Nullable Object audience, String key, Object ... args) {
        String value = TextHelper.getValueByKey(audience, key);
        return TextHelper.resolveArgs(value, args);
    }

    @NotNull
    public static String getValueByKey(@Nullable Object audience, String key) {
        String languageCode = TextHelper.getClientSideLanguageCode(audience);
        String value = TextHelper.getValue(languageCode, key);
        if (value != null) {
            return value;
        }
        String fallbackValue = "(no key `%s` in language `%s`)".formatted(key, languageCode);
        LogUtil.warn("{} triggered by {}", fallbackValue, audience);
        return fallbackValue;
    }

    @Nullable
    private static String getValue(String languageCode, String key) {
        JsonObject languageJson = TextHelper.getLanguageJsonObject(languageCode);
        if (languageJson == UNSUPPORTED_LANGUAGE_MARKER) {
            languageCode = TextHelper.getDefaultLanguageCode();
            languageJson = TextHelper.getLanguageJsonObject(languageCode);
        }
        if (languageJson.has(key)) {
            return languageJson.get(key).getAsString();
        }
        if (!TextHelper.isDefaultLanguageCode(languageCode)) {
            return TextHelper.getValue(TextHelper.getDefaultLanguageCode(), key);
        }
        return null;
    }

    @NotNull
    private static String resolveArgs(@NotNull String string, Object ... args) {
        if (args.length > 0) {
            try {
                return String.format(string, args);
            }
            catch (Exception e) {
                LogUtil.warn("Failed to resolve args for language value `{}` with args `{}`\n\nIt's like a syntax mistake in the language file.\n", string, args);
            }
        }
        return string;
    }

    @NotNull
    public static String parsePlaceholder(@Nullable Object audience, String value) {
        return TextHelper.getText(PLACEHOLDER_PARSER, audience, false, value, new Object[0]).getString();
    }

    @NotNull
    private static class_2561 getText(@NonNull NodeParser parser, @Nullable Object audience, boolean isKey, String keyOrValue, Object ... args) {
        String value;
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        String string = value = isKey ? TextHelper.getValueByKey(audience, keyOrValue) : keyOrValue;
        if (value.equals(SUPPRESS_SENDING_STRING_MARKER)) {
            return SUPPRESS_SENDING_TEXT_MARKER;
        }
        value = TextHelper.resolveArgs(value, args);
        PlaceholderContext placeholderContext = TextHelper.makePlaceholderContext(audience);
        ParserContext parserContext = ParserContext.of((ParserContext.Key)PlaceholderContext.KEY, (Object)placeholderContext);
        return parser.parseText(TextNode.of((String)value), parserContext);
    }

    @NotNull
    private static PlaceholderContext makePlaceholderContext(@Nullable Object audience) {
        PlaceholderContext placeholderContext;
        if (audience instanceof class_2168) {
            audience = ((class_2168)audience).method_44023();
        }
        if (audience instanceof class_1657) {
            class_1657 playerEntity = (class_1657)audience;
            placeholderContext = PlaceholderContext.of((class_1297)playerEntity);
        } else {
            placeholderContext = PlaceholderContext.of((MinecraftServer)ServerHelper.getServer());
        }
        return placeholderContext;
    }

    @NotNull
    private static class_2561 getText(@Nullable Object audience, boolean isKey, String keyOrValue, Object ... args) {
        return TextHelper.getText(POWERFUL_PARSER, audience, isKey, keyOrValue, args);
    }

    @NotNull
    public static class_2561 getTextByKey(@Nullable Object audience, String key, Object ... args) {
        return TextHelper.getText(audience, true, key, args);
    }

    public static String getKeywordValue(@Nullable Object audience, String keyword) {
        return TextHelper.getValueByKey(audience, "keyword." + keyword);
    }

    public static class_5250 getTextByKeyWithKeyword(@Nullable Object audience, String key, String keyword) {
        String replacement = TextHelper.getKeywordValue(audience, keyword);
        String value = TextHelper.getValueByKey(audience, key, replacement);
        return class_2561.method_43470((String)value);
    }

    @NotNull
    public static class_2561 getTextByValue(@Nullable Object audience, String value, Object ... args) {
        return TextHelper.getText(audience, false, value, args);
    }

    @NotNull
    private static List<class_2561> getTextList(@Nullable Object audience, boolean isKey, String keyOrValue) {
        String lines = isKey ? TextHelper.getValueByKey(audience, keyOrValue) : keyOrValue;
        ArrayList<class_2561> ret = new ArrayList<class_2561>();
        for (String line : lines.split("\n|<newline>")) {
            ret.add(TextHelper.getTextByValue(audience, line, new Object[0]));
        }
        return ret;
    }

    @NotNull
    public static List<class_2561> getTextListByKey(@Nullable Object audience, String key) {
        return TextHelper.getTextList(audience, true, key);
    }

    @NotNull
    public static List<class_2561> getTextListByValue(@Nullable Object audience, String value) {
        return TextHelper.getTextList(audience, false, value);
    }

    public static void sendMessageByFlag(@NotNull Object audience, boolean flag) {
        TextHelper.sendMessageByKey(audience, flag ? "on" : "off", new Object[0]);
    }

    public static void sendMessageByKey(@NotNull Object audience, String key, Object ... args) {
        class_2561 text = TextHelper.getTextByKey(audience, key, args);
        if (text == SUPPRESS_SENDING_TEXT_MARKER) {
            LogUtil.debug("Suppress the sending of message: audience = {}, key = {}, args = {}", audience, key, args);
            return;
        }
        if (audience instanceof CommandContext) {
            CommandContext ctx = (CommandContext)audience;
            audience = ctx.getSource();
        }
        if (audience instanceof class_1657) {
            class_1657 playerEntity = (class_1657)audience;
            playerEntity.method_7353(text, false);
            return;
        }
        if (audience instanceof class_2168) {
            class_2168 serverCommandSource = (class_2168)audience;
            serverCommandSource.method_45068(text);
            return;
        }
        LogUtil.error("Can't send message to unknown audience type: {}\nKey: {}\nArgs: {}\n", audience == null ? null : audience.getClass().getName(), key, args);
    }

    public static void sendActionBarByKey(@NotNull class_3222 player, String key, Object ... args) {
        player.method_7353(TextHelper.getTextByKey(player, key, args), true);
    }

    public static void sendBroadcastByKey(@NotNull String key, Object ... args) {
        class_2561 text = TextHelper.getTextByKey(null, key, args);
        LogUtil.info(text.getString(), new Object[0]);
        for (class_3222 player : ServerHelper.getServer().method_3760().method_14571()) {
            TextHelper.sendMessageByKey(player, key, args);
        }
    }

    private static String visitString(class_7417 textContent) {
        StringBuilder stringBuilder = new StringBuilder();
        textContent.method_27659(string -> {
            stringBuilder.append(string);
            return Optional.empty();
        });
        return stringBuilder.toString();
    }

    public static class_5250 replaceTextWithMarker(class_2561 text, String marker, Supplier<class_2561> replacementSupplier) {
        return TextHelper.replaceTextWithRegex(text, "\\[%s\\]".formatted(marker), replacementSupplier);
    }

    public static class_5250 replaceTextWithRegex(class_2561 text, String regex, Supplier<class_2561> nonMemorizedReplacementSupplier) {
        nonMemorizedReplacementSupplier = TextHelper.memoizeSupplier(nonMemorizedReplacementSupplier);
        return TextHelper.replaceText(text, Pattern.compile(regex), nonMemorizedReplacementSupplier);
    }

    private static class_5250 replaceText(class_2561 text, Pattern pattern, Supplier<class_2561> replacementSupplier) {
        class_5250 replacedText;
        String textString = TextHelper.visitString(text.method_10851());
        @Nullable List<class_2561> splits = TextHelper.trySplitString(textString, pattern, replacementSupplier);
        if (splits == null) {
            replacedText = text.method_27662();
        } else {
            class_5250 dummyRoot;
            replacedText = dummyRoot = class_2561.method_43473();
            splits.forEach(arg_0 -> ((class_5250)dummyRoot).method_10852(arg_0));
        }
        replacedText.method_27696(text.method_10866());
        for (class_2561 sibling : text.method_10855()) {
            class_5250 replacedSibling = TextHelper.replaceText(sibling, pattern, replacementSupplier);
            replacedText.method_10852((class_2561)replacedSibling);
        }
        return replacedText;
    }

    @Nullable
    private static List<class_2561> trySplitString(String string, Pattern pattern, Supplier<class_2561> replacementSupplier) {
        Matcher matcher = pattern.matcher(string);
        ArrayList<class_2561> ret = new ArrayList<class_2561>();
        int startIndex = 0;
        while (matcher.find()) {
            int i = matcher.start();
            if (i != startIndex) {
                ret.add((class_2561)class_2561.method_43470((String)string.substring(startIndex, i)));
            }
            ret.add(replacementSupplier.get());
            startIndex = matcher.end();
        }
        if (ret.isEmpty()) {
            return null;
        }
        if (startIndex < string.length()) {
            ret.add((class_2561)class_2561.method_43470((String)string.substring(startIndex)));
        }
        return ret;
    }

    private static <T> Supplier<T> memoizeSupplier(Supplier<T> delegate) {
        AtomicReference value = new AtomicReference();
        return () -> {
            Object val = value.get();
            if (val == null) {
                val = value.updateAndGet(arg_0 -> TextHelper.lambda$memoizeSupplier$2((Supplier)delegate, arg_0));
            }
            return val;
        };
    }

    private TextHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static /* synthetic */ Object lambda$memoizeSupplier$2(Supplier delegate, Object cur) {
        return cur == null ? Objects.requireNonNull(delegate.get()) : cur;
    }

    static {
        TextHelper.writeDefaultLanguageFilesIfAbsent();
        TagRegistry.registerDefault((TextTag)TextTag.self((String)"newline", (String)"formatting", (boolean)true, (nodes, data, parser) -> new LiteralNode("\n")));
    }
}

