/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.auxiliary.minecraft;

import io.github.sakurawald.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.core.structure.SpatialBlock;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UuidHelper {
    private static final String FUJI_UUID = "fuji$uuid";

    @Nullable
    public static String getAttachedUuid(@Nullable class_9279 nbtComponent) {
        if (nbtComponent == null) {
            return null;
        }
        class_2487 root = nbtComponent.method_57461();
        if (!root.method_10545(FUJI_UUID)) {
            return null;
        }
        return root.method_10558(FUJI_UUID);
    }

    public static String getAttachedUuid(SpatialBlock spatialBlock) {
        return UuidHelper.getAttachedUuid((class_1937)spatialBlock.ofDimension(), spatialBlock.ofBlockPos());
    }

    public static String getAttachedUuid(class_1937 world, class_2338 blockPos) {
        byte[] bytes = UuidHelper.toUuid(world, blockPos).getBytes();
        return UUID.nameUUIDFromBytes(bytes).toString();
    }

    public static String toUuid(class_1937 world, class_2338 blockPos) {
        String dimension = RegistryHelper.ofString(world);
        String pos = blockPos.method_10263() + "#" + blockPos.method_10264() + "#" + blockPos.method_10260();
        return dimension + "#" + pos;
    }

    @NotNull
    public static String getOrSetAttachedUuid(class_1799 itemStack) {
        class_9279 nbtComponent = (class_9279)itemStack.method_57824(class_9334.field_49628);
        if (UuidHelper.getAttachedUuid(nbtComponent) == null) {
            nbtComponent = UuidHelper.setGeneratedUuidIfAbsent(nbtComponent);
            itemStack.method_57379(class_9334.field_49628, (Object)nbtComponent);
        }
        return UuidHelper.getAttachedUuid(nbtComponent);
    }

    @NotNull
    private static class_9279 setGeneratedUuidIfAbsent(@Nullable class_9279 nbtComponent) {
        class_2487 root;
        class_2487 class_24872 = root = nbtComponent == null ? new class_2487() : nbtComponent.method_57461();
        if (!root.method_10545(FUJI_UUID)) {
            root.method_10582(FUJI_UUID, String.valueOf(UUID.randomUUID()));
        }
        return class_9279.method_57456((class_2487)root);
    }

    private UuidHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

