/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.command.structure;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.command.argument.structure.Argument;
import io.github.sakurawald.core.command.argument.wrapper.impl.PlayerCollection;
import io.github.sakurawald.core.command.structure.CommandDescriptor;
import io.github.sakurawald.core.command.structure.CommandRequirementDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

public class RetargetCommandDescriptor
extends CommandDescriptor {
    private final int parameterIndexOfCommandTarget;

    private RetargetCommandDescriptor(Method method, List<Argument> arguments, int parameterIndexOfCommandTarget) {
        super(method, arguments);
        this.parameterIndexOfCommandTarget = parameterIndexOfCommandTarget;
    }

    private static Optional<Integer> computeParameterIndexOfCommandTarget(CommandDescriptor descriptor) {
        List<Argument> args = descriptor.collectArgumentsToMakeObjects();
        for (int i = 0; i < args.size(); ++i) {
            Argument argument = args.get(i);
            if (!argument.isCommandTarget()) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public static Optional<RetargetCommandDescriptor> make(CommandDescriptor commandDescriptor) {
        Optional<Integer> indexOpt = RetargetCommandDescriptor.computeParameterIndexOfCommandTarget(commandDescriptor);
        if (indexOpt.isEmpty()) {
            return Optional.empty();
        }
        int index = indexOpt.get();
        List<Argument> transformedArgs = RetargetCommandDescriptor.transformWithOthersArguments(commandDescriptor.arguments);
        RetargetCommandDescriptor retargetCommandDescriptor = new RetargetCommandDescriptor(commandDescriptor.method, transformedArgs, index);
        return Optional.of(retargetCommandDescriptor);
    }

    private static List<Argument> transformWithOthersArguments(List<Argument> arguments) {
        ArrayList<Argument> ret = new ArrayList<Argument>(arguments.stream().filter(it -> it.isCommandSource() || !it.isCommandTarget()).toList());
        for (int argumentIndex = 0; argumentIndex < arguments.size(); ++argumentIndex) {
            Argument argument = arguments.get(argumentIndex);
            if (!argument.isRequiredArgument() && argumentIndex != ret.size() - 1) continue;
            CommandRequirementDescriptor requirement = new CommandRequirementDescriptor(4, null);
            ret.add(argumentIndex, Argument.makeLiteralArgument("others", requirement));
            ret.add(argumentIndex + 1, Argument.makeRequiredArgument(PlayerCollection.class, "others", false, requirement));
            break;
        }
        return ret;
    }

    @Override
    protected Command<class_2168> makeCommandFunctionClosure() {
        return ctx -> {
            if (!RetargetCommandDescriptor.verifyCommandSource((CommandContext<class_2168>)ctx, this)) {
                return -1;
            }
            LogUtil.debug("execute retarget command: initialing command source = {}", ((class_2168)ctx.getSource()).method_9214());
            List<Object> objs = this.makeObjectsByArguments((CommandContext<class_2168>)ctx);
            PlayerCollection targets = (PlayerCollection)objs.getFirst();
            LogUtil.debug("get the targets argument (the first argument in args): {}", ((Collection)targets.getValue()).stream().map(it -> it.method_7334().getName()).toList());
            int finalValue = 1;
            for (class_3222 target : (Collection)targets.getValue()) {
                List<Object> args = objs.subList(1, objs.size());
                if (this.parameterIndexOfCommandTarget < args.size()) {
                    args.set(this.parameterIndexOfCommandTarget, target);
                } else {
                    args.add(this.parameterIndexOfCommandTarget, target);
                }
                LogUtil.debug("invoke command method {} in class {}: target = {}, args = {}", this.method.getName(), this.method.getDeclaringClass().getSimpleName(), target.method_7334().getName(), args);
                try {
                    int singleValue = (Integer)this.method.invoke(null, args.toArray());
                    LogUtil.debug("the return value of command method is {}: target = {}, args = {}", singleValue, target.method_7334().getName(), args);
                    if (singleValue == 1) continue;
                    finalValue = -1;
                }
                catch (Exception wrappedOrUnwrappedException) {
                    return RetargetCommandDescriptor.handleException((CommandContext<class_2168>)ctx, this.method, wrappedOrUnwrappedException);
                }
            }
            return finalValue;
        };
    }
}

