/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.config.transformer.impl;

import com.google.gson.JsonObject;
import com.jayway.jsonpath.DocumentContext;
import io.github.sakurawald.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.core.config.transformer.abst.ConfigurationTransformer;
import io.github.sakurawald.core.config.transformer.impl.FlattenTreeTransformer;
import java.nio.file.Files;
import java.nio.file.LinkOption;

public class FlattenModulesTransformer
extends ConfigurationTransformer {
    @Override
    public void apply() {
        if (Files.notExists(this.getPath(), new LinkOption[0])) {
            return;
        }
        String modulesPath = "$.modules";
        DocumentContext context = this.makeDocumentContext();
        JsonObject modules = (JsonObject)this.read(context, modulesPath);
        for (String topLevelModule : modules.keySet()) {
            FlattenTreeTransformer flattenTreeTransformer = new FlattenTreeTransformer(modulesPath + "." + topLevelModule, "enable", topLevelModule, level -> ReflectionUtil.computeModuleConfigPath(level).resolve("config.json"));
            flattenTreeTransformer.configure(this.getPath());
            flattenTreeTransformer.apply();
        }
    }
}

