/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.manager.impl.backup;

import io.github.sakurawald.Fuji;
import io.github.sakurawald.core.auxiliary.ChronosUtil;
import io.github.sakurawald.core.auxiliary.IOUtil;
import io.github.sakurawald.core.config.Configs;
import io.github.sakurawald.core.manager.impl.backup.BaseBackupManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StandardBackupManager
extends BaseBackupManager {
    public StandardBackupManager() {
        super(Fuji.CONFIG_PATH.resolve("backup"));
    }

    protected boolean skipPath(@NotNull Path dir) {
        for (String other : Configs.configHandler.model().core.backup.skip) {
            if (!dir.equals(Fuji.CONFIG_PATH.resolve(other))) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected List<File> getInputFiles() {
        final ArrayList<File> files = new ArrayList<File>();
        try {
            Files.walkFileTree(Fuji.CONFIG_PATH, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                @NotNull
                public FileVisitResult preVisitDirectory(@NotNull Path dir, BasicFileAttributes attrs) {
                    if (StandardBackupManager.this.BACKUP_PATH.equals(dir)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (StandardBackupManager.this.skipPath(dir)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                @NotNull
                public FileVisitResult visitFile(@NotNull Path file, BasicFileAttributes attrs) {
                    files.add(file.toFile());
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return files;
    }

    protected void trimBackup() {
        List<Path> latestFiles = IOUtil.listLatestFiles(this.BACKUP_PATH);
        Iterator<Path> iterator = latestFiles.iterator();
        while (iterator.hasNext() && latestFiles.size() > Configs.configHandler.model().core.backup.max_slots - 1) {
            Files.delete(iterator.next());
            iterator.remove();
        }
    }

    @Override
    @NotNull
    protected File getOutputFile() {
        String fileName = ChronosUtil.getCurrentDate() + ".zip";
        return this.BACKUP_PATH.resolve(fileName).toFile();
    }

    @Override
    protected void makeBackup() {
        IOUtil.compressFiles(Fuji.CONFIG_PATH.toFile(), this.getInputFiles(), this.getOutputFile());
    }

    @Override
    public void backup() {
        Files.createDirectories(this.BACKUP_PATH, new FileAttribute[0]);
        this.trimBackup();
        this.makeBackup();
    }
}

