/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.manager.impl.bossbar.structure;

public class Interruptible {
    private final boolean enable;
    private final double interruptDistance;
    private final boolean interruptOnDamaged;
    private final boolean interruptInCombat;

    public static Interruptible makeUninterruptible() {
        return new Interruptible(false, 2048.0, false, false);
    }

    public Interruptible(boolean enable, double interruptDistance, boolean interruptOnDamaged, boolean interruptInCombat) {
        this.enable = enable;
        this.interruptDistance = interruptDistance;
        this.interruptOnDamaged = interruptOnDamaged;
        this.interruptInCombat = interruptInCombat;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public double getInterruptDistance() {
        return this.interruptDistance;
    }

    public boolean isInterruptOnDamaged() {
        return this.interruptOnDamaged;
    }

    public boolean isInterruptInCombat() {
        return this.interruptInCombat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Interruptible)) {
            return false;
        }
        Interruptible other = (Interruptible)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        if (Double.compare(this.getInterruptDistance(), other.getInterruptDistance()) != 0) {
            return false;
        }
        if (this.isInterruptOnDamaged() != other.isInterruptOnDamaged()) {
            return false;
        }
        return this.isInterruptInCombat() == other.isInterruptInCombat();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Interruptible;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        long $interruptDistance = Double.doubleToLongBits(this.getInterruptDistance());
        result = result * 59 + (int)($interruptDistance >>> 32 ^ $interruptDistance);
        result = result * 59 + (this.isInterruptOnDamaged() ? 79 : 97);
        result = result * 59 + (this.isInterruptInCombat() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Interruptible(enable=" + this.isEnable() + ", interruptDistance=" + this.getInterruptDistance() + ", interruptOnDamaged=" + this.isInterruptOnDamaged() + ", interruptInCombat=" + this.isInterruptInCombat() + ")";
    }
}

