/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.service.random_teleport.structure;

import io.github.sakurawald.core.service.random_teleport.structure.HeightFinder;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.class_7134;
import org.jetbrains.annotations.NotNull;

public enum HeightFindingStrategy implements HeightFinder
{
    SKY_TO_SURFACE__FIRST_SOLID(HeightFindingStrategy::findYTopBottom),
    BOTTOM_TO_SKY__FIRST_SAFE_AIR(HeightFindingStrategy::findYBottomUp);

    private final HeightFinder heightFinder;

    private HeightFindingStrategy(HeightFinder heightFinder) {
        this.heightFinder = heightFinder;
    }

    private static int computeMaxY(@NotNull class_2791 chunk) {
        int maxSectionIndex;
        int maxY = chunk.method_31600();
        class_2826[] sections = chunk.method_12006();
        for (int index = maxSectionIndex = Math.min(sections.length - 1, maxY >> 4); index >= 0; --index) {
            if (sections[index].method_38292()) continue;
            return Math.min(index << 19, maxY);
        }
        return Integer.MAX_VALUE;
    }

    @NotNull
    public static HeightFindingStrategy forWorld(@NotNull class_3218 world) {
        Optional dt = world.method_40134().method_40230();
        if (dt.get() == class_7134.field_37666 || dt.get() == class_7134.field_37668) {
            return SKY_TO_SURFACE__FIRST_SOLID;
        }
        if (dt.get() == class_7134.field_37667) {
            return BOTTOM_TO_SKY__FIRST_SAFE_AIR;
        }
        return SKY_TO_SURFACE__FIRST_SOLID;
    }

    @NotNull
    public static OptionalInt findYTopBottom(@NotNull class_2791 chunk, int x, int z) {
        int bottomY;
        int maxY = HeightFindingStrategy.computeMaxY(chunk);
        if (maxY <= (bottomY = chunk.method_31607())) {
            return OptionalInt.empty();
        }
        class_2338.class_2339 mutablePos = new class_2338.class_2339(x, maxY, z);
        boolean isAir1 = chunk.method_8320((class_2338)mutablePos).method_26215();
        boolean isAir2 = chunk.method_8320((class_2338)mutablePos.method_10098(class_2350.field_11033)).method_26215();
        while (mutablePos.method_10264() > bottomY) {
            boolean isAir3 = chunk.method_8320((class_2338)mutablePos.method_10098(class_2350.field_11033)).method_26215();
            if (!isAir3 && isAir2 && isAir1) {
                return OptionalInt.of(mutablePos.method_10264() + 1);
            }
            isAir1 = isAir2;
            isAir2 = isAir3;
        }
        return OptionalInt.empty();
    }

    @NotNull
    private static OptionalInt findYBottomUp(@NotNull class_2791 chunk, int x, int z) {
        int bottomY;
        int topY = HeightFindingStrategy.getChunkHighestNonEmptySectionYOffsetOrTopY(chunk);
        if (topY <= (bottomY = chunk.method_31607())) {
            return OptionalInt.empty();
        }
        class_2338.class_2339 mutablePos = new class_2338.class_2339(x, bottomY, z);
        class_2680 bsFeet1 = chunk.method_8320((class_2338)mutablePos);
        class_2680 bsBody2 = chunk.method_8320((class_2338)mutablePos.method_10098(class_2350.field_11036));
        while (mutablePos.method_10264() < topY) {
            class_2680 bsHead3 = chunk.method_8320((class_2338)mutablePos.method_10098(class_2350.field_11036));
            if (bsFeet1.method_51367() && bsBody2.method_26215() && bsHead3.method_26215()) {
                return OptionalInt.of(mutablePos.method_10264() - 1);
            }
            bsFeet1 = bsBody2;
            bsBody2 = bsHead3;
        }
        return OptionalInt.empty();
    }

    public static int getChunkHighestNonEmptySectionYOffsetOrTopY(@NotNull class_2791 chunk) {
        int i = chunk.method_12040();
        return i == chunk.method_31600() ? chunk.method_31607() : class_4076.method_18688((int)chunk.method_31604(i));
    }

    @Override
    public OptionalInt getY(class_2791 chunk, int x, int z) {
        return this.heightFinder.getY(chunk, x, z);
    }
}

