/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.service.style_striper;

import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.minecraft.PermissionHelper;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1657;

public final class StyleStriper {
    private static final Pattern TAG_RESOLVER = Pattern.compile("<([^>]+)>");

    public static String stripe(class_1657 player, String type, String input) {
        for (String tag : StyleStriper.resolveTags(input)) {
            String tagType = StyleStriper.extractTagType(tag);
            if (StyleStriper.canUse(player, type, tagType)) continue;
            input = input.replace(tag, "");
        }
        return input;
    }

    private static String extractTagType(String tag) {
        int colonIndex;
        if ((tag = tag.trim()).startsWith("/")) {
            tag = tag.substring(1);
        }
        if (tag.endsWith("\\")) {
            tag = tag.substring(0, tag.length() - 1);
        }
        if ((colonIndex = tag.indexOf(58)) != -1) {
            return tag.substring(0, colonIndex);
        }
        int blankIndex = tag.indexOf(32);
        if (blankIndex != -1) {
            return tag.substring(0, blankIndex);
        }
        return tag;
    }

    private static Set<String> resolveTags(String string) {
        HashSet<String> tags = new HashSet<String>();
        Matcher matcher = TAG_RESOLVER.matcher(string);
        while (matcher.find()) {
            String tag = matcher.group(1);
            tags.add(tag);
        }
        LogUtil.debug("resolve style tags: {}", tags);
        return tags;
    }

    private static boolean canUse(class_1657 player, String type, String tag) {
        String permission = "fuji.style.%s.%s".formatted(type, tag);
        return PermissionHelper.hasPermission(player.method_5667(), permission);
    }

    private StyleStriper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

