/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.structure;

import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DateParser {
    private static final int SECOND_TO_SECOND = 1;
    private static final int MINUTE_TO_SECOND = 60;
    private static final int HOUR_TO_SECOND = 3600;
    private static final int DAY_TO_SECOND = 86400;
    private static final int WEEK_TO_SECOND = 604800;
    private static final int MONTH_TO_SECOND = 2592000;
    private static final int YEAR_TO_SECOND = 31104000;
    private static final Pattern DATE_PARSER_DSL = Pattern.compile("(\\d+)([smhdwMy])");

    public static Date parseDate(String period) {
        Matcher matcher = DATE_PARSER_DSL.matcher(period);
        int accumulateSeconds = 0;
        block18: while (matcher.find()) {
            String unit;
            int quantity = Integer.parseInt(matcher.group(1));
            switch (unit = matcher.group(2)) {
                case "s": {
                    accumulateSeconds += quantity * 1;
                    continue block18;
                }
                case "m": {
                    accumulateSeconds += quantity * 60;
                    continue block18;
                }
                case "h": {
                    accumulateSeconds += quantity * 3600;
                    continue block18;
                }
                case "d": {
                    accumulateSeconds += quantity * 86400;
                    continue block18;
                }
                case "w": {
                    accumulateSeconds += quantity * 604800;
                    continue block18;
                }
                case "M": {
                    accumulateSeconds += quantity * 2592000;
                    continue block18;
                }
                case "y": {
                    accumulateSeconds += quantity * 31104000;
                    continue block18;
                }
            }
            throw new IllegalArgumentException("Unknown time unit: " + unit);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, accumulateSeconds);
        return calendar.getTime();
    }

    private DateParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

