/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.back;

import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.ChronosUtil;
import io.github.sakurawald.core.auxiliary.minecraft.PermissionHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandRequirement;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.command.annotation.CommandTarget;
import io.github.sakurawald.core.command.argument.wrapper.impl.Dimension;
import io.github.sakurawald.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.core.structure.SpatialPose;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.back.config.model.BackConfigModel;
import io.github.sakurawald.module.initializer.back.config.model.BackLocationHistoryModel;
import io.github.sakurawald.module.initializer.back.structure.LocationEntry;
import io.github.sakurawald.module.initializer.back.structure.LocationHistory;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<BackConfigModel> config = new ObjectConfigurationHandler<BackConfigModel>("config.json", BackConfigModel.class);
    private static final BaseConfigurationHandler<BackLocationHistoryModel> savedPositionConfig = new ObjectConfigurationHandler<BackLocationHistoryModel>("location-history.json", BackLocationHistoryModel.class).autoSaveEveryMinute();

    private static <R> R withLocationHistory(@NotNull class_3222 player, Function<LocationHistory, R> function) {
        String playerName = player.method_7334().getName();
        BackInitializer.savedPositionConfig.model().player2history.computeIfAbsent(playerName, k -> new LocationHistory());
        LocationHistory locationHistory = BackInitializer.savedPositionConfig.model().player2history.get(playerName);
        return function.apply(locationHistory);
    }

    @CommandNode(value="back push")
    @CommandRequirement(level=4)
    @Document(value="Push current location into the back location history.")
    private static int $push(@CommandSource @CommandTarget class_3222 player) {
        return BackInitializer.withLocationHistory(player, locationHistory -> {
            LocationEntry locationEntry = LocationEntry.makeLocationEntry(player);
            BackInitializer.pushEntryAndTrim(player, locationHistory, locationEntry);
            return 1;
        });
    }

    @CommandNode(value="back clear")
    @CommandRequirement(level=4)
    @Document(value="Clear the back location history.")
    private static int $clear(@CommandSource CommandContext<class_2168> source, @CommandTarget class_3222 player) {
        return BackInitializer.withLocationHistory(player, locationHistory -> {
            locationHistory.clearEntries();
            TextHelper.sendMessageByKey(source, "back.clear", player.method_7334().getName());
            return 1;
        });
    }

    @CommandNode(value="back list")
    @CommandRequirement(level=4)
    @Document(value="List the back location history.")
    private static int $list(@CommandSource CommandContext<class_2168> source, class_3222 player) {
        return BackInitializer.backListWithParameters((class_2168)source.getSource(), player);
    }

    @CommandNode(value="back list")
    @Document(value="List the back location history.")
    private static int $list(@CommandSource class_3222 source) {
        return BackInitializer.backListWithParameters(source.method_5671(), source);
    }

    private static Integer backListWithParameters(class_2168 source, class_3222 player) {
        return BackInitializer.withLocationHistory(player, locationHistory -> {
            String targetPlayerName = player.method_7334().getName();
            TextHelper.sendMessageByKey(source, "back.list", targetPlayerName);
            locationHistory.listEntries().forEachRemaining(it -> {
                SpatialPose location = it.getLocation();
                TextHelper.sendMessageByKey(source, "back.list.entry", location.getLevel(), location.getX(), location.getY(), location.getZ(), ChronosUtil.toStandardDateFormat(it.getSavedTimestamp()));
            });
            return 1;
        });
    }

    @CommandNode(value="back")
    @Document(value="Back to the specified location.")
    private static int $back(@CommandSource class_3222 player) {
        return BackInitializer.backWithParameters(player, 1, null);
    }

    @CommandNode(value="back")
    @Document(value="Back to the specified location.")
    private static int $back(@CommandSource class_3222 player, int lastNLocation) {
        return BackInitializer.backWithParameters(player, lastNLocation, null);
    }

    @CommandNode(value="back")
    @Document(value="Back to the specified location.")
    private static int $back(@CommandSource class_3222 player, int lastNLocation, Dimension targetDimension) {
        return BackInitializer.backWithParameters(player, lastNLocation, targetDimension);
    }

    @CommandNode(value="back")
    @Document(value="Back to the specified location.")
    private static int $back(@CommandSource class_3222 player, Dimension targetDimension) {
        return BackInitializer.backWithParameters(player, 1, targetDimension);
    }

    private static int backWithParameters(@NotNull class_3222 player, int lastNLocation, @Nullable Dimension targetDimension) {
        return BackInitializer.withLocationHistory(player, locationHistory -> {
            LocationEntry latestEntry = locationHistory.findEntry(lastNLocation, targetDimension);
            if (latestEntry == null) {
                TextHelper.sendActionBarByKey(player, "back.no_previous_position", new Object[0]);
                throw new AbortCommandExecutionException();
            }
            latestEntry.getLocation().teleport(player);
            return 1;
        });
    }

    private static int getMaxBackLocationEntriesToSave(@NotNull class_3222 player) {
        Optional<Integer> value = PermissionHelper.getMeta(player.method_5667(), "fuji.back.max_location_entries_to_save", Integer::valueOf);
        return value.orElse(BackInitializer.config.model().max_back_location_entries_to_save);
    }

    private static boolean shouldSaveCurrentLocation(@NotNull class_3222 player) {
        return BackInitializer.withLocationHistory(player, locationHistory -> {
            LocationEntry latestEntry = locationHistory.getLatestEntry();
            if (latestEntry == null) {
                return true;
            }
            SpatialPose latestLocation = latestEntry.getLocation();
            double ignoreDistance = BackInitializer.config.model().ignore_distance;
            if (latestLocation.sameLevel(player.method_37908()) && player.method_19538().method_1028(latestLocation.getX(), latestLocation.getY(), latestLocation.getZ()) > ignoreDistance * ignoreDistance) {
                return false;
            }
            return true;
        });
    }

    public static void trySaveCurrentLocation(@NotNull class_3222 player) {
        BackInitializer.withLocationHistory(player, locationHistory -> {
            if (BackInitializer.shouldSaveCurrentLocation(player)) {
                LocationEntry locationEntry = LocationEntry.makeLocationEntry(player);
                BackInitializer.pushEntryAndTrim(player, locationHistory, locationEntry);
            }
            return null;
        });
    }

    private static void pushEntryAndTrim(@NotNull class_3222 player, @NotNull LocationHistory locationHistory, @NotNull LocationEntry locationEntry) {
        locationHistory.pushEntry(locationEntry);
        locationHistory.trimEntries(BackInitializer.getMaxBackLocationEntriesToSave(player));
    }
}

