/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.command_attachment;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.auxiliary.minecraft.UuidHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandRequirement;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.core.command.executor.CommandExecutor;
import io.github.sakurawald.core.command.structure.ExtendedCommandSource;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.core.manager.Managers;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.command_attachment.command.argument.wrapper.ExecuteAsType;
import io.github.sakurawald.module.initializer.command_attachment.command.argument.wrapper.InteractType;
import io.github.sakurawald.module.initializer.command_attachment.config.model.CommandAttachmentModel;
import io.github.sakurawald.module.initializer.command_attachment.job.TestSteppingOnBlockJob;
import io.github.sakurawald.module.initializer.command_attachment.structure.BlockCommandAttachmentNode;
import io.github.sakurawald.module.initializer.command_attachment.structure.CommandAttachmentNode;
import io.github.sakurawald.module.initializer.command_attachment.structure.CommandAttackmentType;
import io.github.sakurawald.module.initializer.command_attachment.structure.EntityCommandAttachmentNode;
import io.github.sakurawald.module.initializer.command_attachment.structure.ItemStackCommandAttachmentNode;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CommandNode(value="command-attachment")
@CommandRequirement(level=4)
public class CommandAttachmentInitializer
extends ModuleInitializer {
    private static final String COMMAND_ATTACHMENT_SUBJECT_NAME = "command-attachment";
    private static final Map<String, String> player2uuid = new HashMap<String, String>();

    private static void testSteppingBlockForPlayer(class_3222 player) {
        String playerName = player.method_7334().getName();
        String originalUuid = player2uuid.get(playerName);
        String uuid = UuidHelper.getAttachedUuid((class_1937)player.method_51469(), player.method_23312());
        if (uuid.equals(originalUuid)) {
            return;
        }
        player2uuid.put(playerName, uuid);
        if (!CommandAttachmentInitializer.existsAttachmentModel(uuid)) {
            return;
        }
        ServerHelper.getServer().method_40000(() -> CommandAttachmentInitializer.triggerAttachmentModel(uuid, (class_1657)player, List.of(InteractType.STEP_ON)));
    }

    public static void testSteppingBlockForPlayers() {
        ServerHelper.getPlayers().forEach(CommandAttachmentInitializer::testSteppingBlockForPlayer);
    }

    public static boolean existsAttachmentModel(String uuid) {
        return Managers.getAttachmentManager().existsAttachment(COMMAND_ATTACHMENT_SUBJECT_NAME, uuid);
    }

    private static CommandAttachmentModel getAttachmentModel(String uuid) {
        CommandAttachmentModel model;
        try {
            String attachment = Managers.getAttachmentManager().getAttachment(COMMAND_ATTACHMENT_SUBJECT_NAME, uuid);
            model = (CommandAttachmentModel)BaseConfigurationHandler.getGson().fromJson(attachment, CommandAttachmentModel.class);
        }
        catch (IOException e) {
            model = new CommandAttachmentModel();
            String json = BaseConfigurationHandler.getGson().toJson((Object)model);
            Managers.getAttachmentManager().setAttachment(COMMAND_ATTACHMENT_SUBJECT_NAME, uuid, json);
        }
        return model;
    }

    private static void setAttachmentModel(String uuid, CommandAttachmentModel model) {
        String json = BaseConfigurationHandler.getGson().toJson((Object)model);
        Managers.getAttachmentManager().setAttachment(COMMAND_ATTACHMENT_SUBJECT_NAME, uuid, json);
    }

    public static void triggerAttachmentModel(String uuid, class_1657 player, List<InteractType> receivedInteractTypes) {
        CommandAttachmentModel model = CommandAttachmentInitializer.getAttachmentModel(uuid);
        for (CommandAttachmentNode e : model.getEntries()) {
            ItemStackCommandAttachmentNode ie;
            if (!receivedInteractTypes.contains((Object)e.getInteractType()) || e.getUseTimes() >= e.getMaxUseTimes()) continue;
            ExecuteAsType executeAsType = e.getExecuteAsType();
            class_2168 source = player.method_5671();
            switch (executeAsType) {
                case CONSOLE: {
                    CommandExecutor.execute(ExtendedCommandSource.asConsole(source), e.getCommand());
                    break;
                }
                case PLAYER: {
                    CommandExecutor.execute(ExtendedCommandSource.asPlayer(source, player), e.getCommand());
                    break;
                }
                case FAKE_OP: {
                    CommandExecutor.execute(ExtendedCommandSource.asFakeOp(source, player), e.getCommand());
                }
            }
            e.setUseTimes(e.getUseTimes() + 1);
            if (!(e instanceof ItemStackCommandAttachmentNode) || !(ie = (ItemStackCommandAttachmentNode)e).isDestroyItem() || e.getUseTimes() < e.getMaxUseTimes()) continue;
            player.method_6047().method_7934(1);
        }
        CommandAttachmentInitializer.setAttachmentModel(uuid, model);
    }

    @CommandNode(value="attach-item-one")
    @Document(value="Attach one command to an item.")
    private static int attachItemOne(@CommandSource class_3222 player, @Document(value="The interaction type to trigger this command.") Optional<InteractType> interactType, @Document(value="Max use times of this command.") Optional<Integer> maxUseTimes, @Document(value="Execute this command as who?") Optional<ExecuteAsType> executeAsType, @Document(value="Should we destroy the item if the use times exceed.") Optional<Boolean> destroyItem, @Document(value="The command.") GreedyString command) {
        class_1799 mainHandStack = player.method_6047();
        CommandAttachmentInitializer.checkItemStackInHand(player, mainHandStack);
        String uuid = UuidHelper.getOrSetAttachedUuid(mainHandStack);
        CommandAttachmentModel model = CommandAttachmentInitializer.getAttachmentModel(uuid);
        String $command = (String)command.getValue();
        InteractType $interactType = interactType.orElse(InteractType.BOTH);
        ExecuteAsType $executeAsType = executeAsType.orElse(ExecuteAsType.FAKE_OP);
        Integer $maxUseTimes = maxUseTimes.orElse(Integer.MAX_VALUE);
        Boolean $destroyItem = destroyItem.orElse(true);
        model.getEntries().add(new ItemStackCommandAttachmentNode($command, $interactType, $executeAsType, $maxUseTimes, 0, $destroyItem));
        CommandAttachmentInitializer.setAttachmentModel(uuid, model);
        return 1;
    }

    @CommandNode(value="attach-entity-one")
    @Document(value="Attach one command to an entity.")
    private static int attachEntityOne(@CommandSource class_3222 player, @Document(value="The target entity.") class_1297 entity, @Document(value="The interaction type to trigger this command.") Optional<InteractType> interactType, @Document(value="Max use times of this command.") Optional<Integer> maxUseTimes, @Document(value="Execute this command as who?") Optional<ExecuteAsType> executeAsType, @Document(value="The command") GreedyString command) {
        String uuid = entity.method_5845();
        CommandAttachmentModel model = CommandAttachmentInitializer.getAttachmentModel(uuid);
        String $command = (String)command.getValue();
        InteractType $interactType = interactType.orElse(InteractType.BOTH);
        ExecuteAsType $executeAsType = executeAsType.orElse(ExecuteAsType.FAKE_OP);
        Integer $maxUseTimes = maxUseTimes.orElse(Integer.MAX_VALUE);
        model.getEntries().add(new EntityCommandAttachmentNode($command, $interactType, $executeAsType, $maxUseTimes, 0));
        CommandAttachmentInitializer.setAttachmentModel(uuid, model);
        return 1;
    }

    @CommandNode(value="attach-block-one")
    private static int attachBlockOne(@CommandSource class_3222 player, class_2338 blockPos, @Document(value="The interaction type to trigger this command.") Optional<InteractType> interactType, @Document(value="Max use times of this command.") Optional<Integer> maxUseTimes, @Document(value="Execute this command as who?") Optional<ExecuteAsType> executeAsType, @Document(value="The command") GreedyString command) {
        String uuid = UuidHelper.getAttachedUuid((class_1937)player.method_51469(), blockPos);
        CommandAttachmentModel model = CommandAttachmentInitializer.getAttachmentModel(uuid);
        String $command = (String)command.getValue();
        InteractType $interactType = interactType.orElse(InteractType.BOTH);
        ExecuteAsType $executeAsType = executeAsType.orElse(ExecuteAsType.FAKE_OP);
        Integer $maxUseTimes = maxUseTimes.orElse(Integer.MAX_VALUE);
        String createdIn = UuidHelper.toUuid(player.method_37908(), blockPos);
        model.getEntries().add(new BlockCommandAttachmentNode(createdIn, $command, $interactType, $executeAsType, (int)$maxUseTimes, 0));
        CommandAttachmentInitializer.setAttachmentModel(uuid, model);
        return 1;
    }

    private static void checkItemStackInHand(class_3222 player, class_1799 mainHandStack) {
        if (mainHandStack.method_7960()) {
            TextHelper.sendMessageByKey(player, "item.empty.not_allow", new Object[0]);
            throw new AbortCommandExecutionException();
        }
    }

    @CommandNode(value="detach-item-all")
    @Document(value="Detach all attached commands in the item.")
    private static int detachItemAll(@CommandSource class_3222 player) {
        class_1799 mainHandStack = player.method_6047();
        CommandAttachmentInitializer.checkItemStackInHand(player, mainHandStack);
        String uuid = UuidHelper.getOrSetAttachedUuid(mainHandStack);
        CommandAttachmentInitializer.doDetachAttachment(player, uuid);
        return 1;
    }

    @CommandNode(value="detach-entity-all")
    @Document(value="Detach all attached commands in the entity.")
    private static int detachEntityAll(@CommandSource class_3222 player, class_1297 entity) {
        String uuid = entity.method_5845();
        CommandAttachmentInitializer.doDetachAttachment(player, uuid);
        return 1;
    }

    @CommandNode(value="detach-block-all")
    @Document(value="Detach all attached commands in the block.")
    private static int detachBlockAll(@CommandSource class_3222 player, class_2338 blockPos) {
        String uuid = UuidHelper.getAttachedUuid((class_1937)player.method_51469(), blockPos);
        CommandAttachmentInitializer.doDetachAttachment(player, uuid);
        return 1;
    }

    private static void doDetachAttachment(class_3222 player, String uuid) {
        Managers.getAttachmentManager().unsetAttachment(COMMAND_ATTACHMENT_SUBJECT_NAME, uuid);
    }

    @CommandNode(value="query-item")
    @Document(value="Query all attached commands in the item.")
    private static int queryItem(@CommandSource class_3222 player) {
        class_1799 mainHandStack = player.method_6047();
        CommandAttachmentInitializer.checkItemStackInHand(player, mainHandStack);
        String uuid = UuidHelper.getAttachedUuid((class_9279)mainHandStack.method_57824(class_9334.field_49628));
        CommandAttachmentInitializer.doQueryAttachment(player, uuid);
        return 1;
    }

    @CommandNode(value="query-entity")
    @Document(value="Query all attached commands in the entity.")
    private static int queryEntity(@CommandSource class_3222 player, class_1297 entity) {
        String uuid = entity.method_5845();
        CommandAttachmentInitializer.doQueryAttachment(player, uuid);
        return 1;
    }

    @CommandNode(value="query-block")
    @Document(value="Query all attached commands in the block.")
    private static int queryBlock(@CommandSource class_3222 player, class_2338 blockPos) {
        String uuid = UuidHelper.getAttachedUuid((class_1937)player.method_51469(), blockPos);
        CommandAttachmentInitializer.doQueryAttachment(player, uuid);
        return 1;
    }

    private static void doQueryAttachment(class_3222 player, String uuid) {
        if (!Managers.getAttachmentManager().existsAttachment(COMMAND_ATTACHMENT_SUBJECT_NAME, uuid)) {
            TextHelper.sendMessageByKey(player, "command_attachment.query.no_attachment", new Object[0]);
            throw new AbortCommandExecutionException();
        }
        String attachment = Managers.getAttachmentManager().getAttachment(COMMAND_ATTACHMENT_SUBJECT_NAME, uuid);
        player.method_43496((class_2561)class_2561.method_43470((String)attachment));
    }

    @Override
    protected void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> new TestSteppingOnBlockJob().schedule());
    }

    @Override
    protected void registerGsonTypeAdapter() {
        BaseConfigurationHandler.registerTypeAdapter(CommandAttachmentNode.class, new CommandAttachmentNodeAdapter());
    }

    private static class CommandAttachmentNodeAdapter
    implements JsonDeserializer<CommandAttachmentNode> {
        private CommandAttachmentNodeAdapter() {
        }

        @Nullable
        public CommandAttachmentNode deserialize(@NotNull JsonElement json, Type typeOfT, @NotNull JsonDeserializationContext context) throws JsonParseException {
            String type;
            if (!json.getAsJsonObject().has("type")) {
                json.getAsJsonObject().addProperty("type", CommandAttackmentType.ITEMSTACK.name());
            }
            if ((type = json.getAsJsonObject().get("type").getAsString()).equals(CommandAttackmentType.ITEMSTACK.name())) {
                return (CommandAttachmentNode)context.deserialize(json, ItemStackCommandAttachmentNode.class);
            }
            if (type.equals(CommandAttackmentType.ENTITY.name())) {
                return (CommandAttachmentNode)context.deserialize(json, EntityCommandAttachmentNode.class);
            }
            if (type.equals(CommandAttackmentType.BLOCK.name())) {
                return (CommandAttachmentNode)context.deserialize(json, BlockCommandAttachmentNode.class);
            }
            throw new IllegalArgumentException("The type of command attachment entry is not supported");
        }
    }
}

