/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.command_cooldown;

import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.minecraft.PlaceholderHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandRequirement;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.command.argument.wrapper.impl.GreedyStringList;
import io.github.sakurawald.core.command.argument.wrapper.impl.StringList;
import io.github.sakurawald.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.core.command.executor.CommandExecutor;
import io.github.sakurawald.core.command.structure.ExtendedCommandSource;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.core.structure.Cooldown;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.command_cooldown.command.argument.wrapper.CommandCooldownName;
import io.github.sakurawald.module.initializer.command_cooldown.config.model.CommandCooldownConfigModel;
import io.github.sakurawald.module.initializer.command_cooldown.structure.CommandCooldown;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@CommandNode(value="command-cooldown")
@CommandRequirement(level=4)
public class CommandCooldownInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<CommandCooldownConfigModel> config = new ObjectConfigurationHandler<CommandCooldownConfigModel>("config.json", CommandCooldownConfigModel.class){

        @Override
        public void beforeWriteStorage() {
            ((CommandCooldownConfigModel)this.model()).namedCooldown.list.values().stream().filter(it -> !it.isPersistent()).forEach(it -> it.getTimestamp().clear());
        }
    }.autoSaveEveryMinute();
    public static final class_5250 NOT_COOLDOWN_FOUND = class_2561.method_43470((String)"NOT_COOLDOWN_FOUND");
    private static final Map<String, Cooldown<String>> player2cooldown = new HashMap<String, Cooldown<String>>();

    public static long computeCooldown(class_3222 player, @NotNull String commandLine) {
        String name = player.method_7334().getName();
        Cooldown cooldown = player2cooldown.computeIfAbsent(name, k -> new Cooldown());
        Optional<Map.Entry> first = CommandCooldownInitializer.config.model().unnamed_cooldown.entrySet().stream().filter(it -> commandLine.matches((String)it.getKey())).findFirst();
        return first.map(entry -> cooldown.tryUse((String)entry.getKey(), (Long)entry.getValue())).orElse(-1L);
    }

    @CommandNode(value="test")
    @Document(value="Test a named-cooldown, and execute success commands or failed commands.")
    private static int test(@CommandSource class_2168 source, @Document(value="The named-cooldown.") CommandCooldownName name, @Document(value="The target player.") class_3222 player, @Document(value="The commands to execute if the test is failed.") Optional<StringList> onFailed, @Document(value="The commands to execute if the test is success.") GreedyStringList onSuccess) {
        CommandCooldownInitializer.ensureExist(source, name);
        CommandCooldown cooldown = CommandCooldownInitializer.config.model().namedCooldown.list.get(name.getValue());
        StringList $onFailed = onFailed.orElse(new StringList(Collections.emptyList()));
        String key = player.method_7334().getName();
        long leftTime = cooldown.tryUse(key, (Long)cooldown.getCooldownMs());
        int usage = cooldown.getUsage().getOrDefault(key, 0);
        int leftUsage = cooldown.getMaxUsage() - usage;
        if (leftTime > 0L || leftUsage <= 0) {
            CommandExecutor.execute(ExtendedCommandSource.asConsole(player.method_5671()), (List)$onFailed.getValue());
            return -1;
        }
        cooldown.getUsage().compute(key, (k, v) -> v == null ? 1 : v + 1);
        CommandExecutor.execute(ExtendedCommandSource.asConsole(player.method_5671()), (List)onSuccess.getValue());
        return 1;
    }

    @CommandNode(value="create")
    @Document(value="Create a named-cooldown.")
    private static int create(@CommandSource class_2168 source, @Document(value="The name for named-cooldown.") String name, @Document(value="How long is the cooling time ms of this named-cooldown.") long cooldownMs, @Document(value="Max usage times of this named-cooldown. (per-player/global)") Optional<Integer> maxUsage, @Document(value="Should we persist this named-cooldown on server shutdown.") Optional<Boolean> persistent, @Document(value="Is this named-cooldown global or per-player.") Optional<Boolean> global) {
        CommandCooldownInitializer.ensureNotExist(source, name);
        int $maxUsage = maxUsage.orElse(Integer.MAX_VALUE);
        Boolean $persistent = persistent.orElse(true);
        Boolean $global = global.orElse(false);
        CommandCooldown commandCooldown = new CommandCooldown(name, cooldownMs, $maxUsage, $persistent, $global);
        CommandCooldownInitializer.config.model().namedCooldown.list.put(name, commandCooldown);
        TextHelper.sendMessageByKey(source, "command_cooldown.created", name);
        return 1;
    }

    @CommandNode(value="delete")
    @Document(value="Delete a named-cooldown.")
    private static int delete(@CommandSource class_2168 source, CommandCooldownName name) {
        CommandCooldownInitializer.ensureExist(source, name);
        String key = (String)name.getValue();
        CommandCooldownInitializer.config.model().namedCooldown.list.remove(key);
        TextHelper.sendMessageByKey(source, "command_cooldown.deleted", name.getValue());
        return 1;
    }

    @CommandNode(value="list")
    @Document(value="List all named-cooldown.")
    private static int list(@CommandSource class_2168 source) {
        CommandCooldownInitializer.config.model().namedCooldown.list.keySet().forEach(it -> source.method_45068((class_2561)class_2561.method_43470((String)it)));
        return 1;
    }

    @CommandNode(value="reset")
    @Document(value="Reset the timestamp of a named-cooldown for a player. (The usage times will not be reset)")
    private static int reset(@CommandSource class_2168 source, CommandCooldownName name, class_3222 player) {
        CommandCooldownInitializer.ensureExist(source, name);
        CommandCooldown commandCooldown = CommandCooldownInitializer.config.model().namedCooldown.list.get(name.getValue());
        String key = player.method_7334().getName();
        commandCooldown.getTimestamp().put(key, 0L);
        TextHelper.sendMessageByKey(source, "command_cooldown.reset", key, name.getValue());
        return 1;
    }

    private static void ensureExist(class_2168 source, CommandCooldownName name) {
        if (!CommandCooldownInitializer.config.model().namedCooldown.list.containsKey(name.getValue())) {
            TextHelper.sendMessageByKey(source, "command_cooldown.not_found", name.getValue());
            throw new AbortCommandExecutionException();
        }
    }

    private static void ensureNotExist(class_2168 source, String name) {
        if (CommandCooldownInitializer.config.model().namedCooldown.list.containsKey(name)) {
            TextHelper.sendMessageByKey(source, "command_cooldown.already_exists", name);
            throw new AbortCommandExecutionException();
        }
    }

    @Override
    protected void registerPlaceholder() {
        PlaceholderHelper.withPlayer("command_cooldown_left_time", (player, args) -> {
            CommandCooldown cooldown = CommandCooldownInitializer.config.model().namedCooldown.list.get(args);
            if (cooldown == null) {
                return NOT_COOLDOWN_FOUND;
            }
            String key = player.method_7334().getName();
            long leftTime = cooldown.getCooldown(key, (Long)cooldown.getCooldownMs());
            leftTime = Math.max(0L, leftTime);
            return class_2561.method_43470((String)String.valueOf(leftTime));
        });
        PlaceholderHelper.withPlayer("command_cooldown_left_usage", (player, args) -> {
            CommandCooldown cooldown = CommandCooldownInitializer.config.model().namedCooldown.list.get(args);
            if (cooldown == null) {
                return NOT_COOLDOWN_FOUND;
            }
            String key = player.method_7334().getName();
            int usage = cooldown.getUsage().getOrDefault(key, 0);
            int leftUsage = cooldown.getMaxUsage() - usage;
            return class_2561.method_43470((String)String.valueOf(leftUsage));
        });
    }
}

