/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.command_meta.shell;

import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandRequirement;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.command_meta.shell.config.ShellConfigModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

public class ShellInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<ShellConfigModel> config = new ObjectConfigurationHandler<ShellConfigModel>("config.json", ShellConfigModel.class);

    private static void checkSecurity(CommandContext<class_2168> ctx) {
        ShellConfigModel config = ShellInitializer.config.model();
        if (!config.enable_warning.equals("CONFIRM")) {
            TextHelper.sendMessageByKey(ctx.getSource(), "shell.failed.rtfm", new Object[0]);
            throw new AbortCommandExecutionException();
        }
        if (config.security.only_allow_console && ((class_2168)ctx.getSource()).method_44023() != null) {
            TextHelper.sendMessageByKey(ctx.getSource(), "command.console_only", new Object[0]);
            throw new AbortCommandExecutionException();
        }
        if (((class_2168)ctx.getSource()).method_9214() != null && !config.security.allowed_player_names.contains(((class_2168)ctx.getSource()).method_9214())) {
            TextHelper.sendMessageByKey(ctx.getSource(), "shell.failed.not_in_allowed_list", new Object[0]);
            throw new AbortCommandExecutionException();
        }
    }

    @CommandNode(value="shell")
    @CommandRequirement(level=4)
    @Document(value="Execute a shell command in host os.")
    private static int shell(@CommandSource CommandContext<class_2168> ctx, GreedyString rest) {
        ShellInitializer.checkSecurity(ctx);
        String $rest = (String)rest.getValue();
        CompletableFuture.runAsync(() -> {
            try {
                LogUtil.info("shell exec: {}", $rest);
                Process process = Runtime.getRuntime().exec($rest, null, null);
                InputStream inputStream = process.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                try {
                    String line;
                    StringBuilder output = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        output.append(line).append("\n");
                    }
                    process.waitFor();
                    LogUtil.info(output.toString(), new Object[0]);
                    ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)output.toString()));
                }
                finally {
                    if (Collections.singletonList(reader).get(0) != null) {
                        reader.close();
                    }
                }
            }
            catch (IOException | InterruptedException e) {
                LogUtil.error("failed to execute a shell command.", e);
            }
        });
        return 1;
    }
}

