/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.command_scheduler;

import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandRequirement;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.core.manager.Managers;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.command_scheduler.command.argument.wrapper.JobName;
import io.github.sakurawald.module.initializer.command_scheduler.config.model.CommandSchedulerConfigModel;
import io.github.sakurawald.module.initializer.command_scheduler.gui.JobGui;
import io.github.sakurawald.module.initializer.command_scheduler.job.CommandScheduleJob;
import io.github.sakurawald.module.initializer.command_scheduler.structure.Job;
import java.util.List;
import net.minecraft.class_3222;
import org.quartz.JobDataMap;

@CommandNode(value="command-scheduler")
@CommandRequirement(level=4)
public class CommandSchedulerInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<CommandSchedulerConfigModel> scheduler = new ObjectConfigurationHandler<CommandSchedulerConfigModel>("scheduler.json", CommandSchedulerConfigModel.class).autoSaveEveryMinute();

    @Override
    protected void onInitialize() {
        this.updateJobs();
    }

    @Override
    protected void onReload() {
        this.updateJobs();
    }

    @CommandNode(value="list")
    @Document(value="List all defined jobs.")
    private static int list(@CommandSource class_3222 player) {
        List<Job> jobs = CommandSchedulerInitializer.scheduler.model().jobs;
        new JobGui(player, jobs, 0).open();
        return 1;
    }

    @CommandNode(value="trigger")
    @Document(value="Trigger a job manually.")
    private static int trigger(JobName jobName) {
        CommandSchedulerInitializer.scheduler.model().jobs.stream().filter(it -> it.getName().equals(jobName.getValue())).findFirst().ifPresent(Job::trigger);
        return 1;
    }

    private void updateJobs() {
        LogUtil.info("un-schedule jobs", new Object[0]);
        Managers.getScheduleManager().deleteJobs(CommandScheduleJob.class);
        CommandSchedulerInitializer.scheduler.model().jobs.forEach(scheduleJob -> {
            scheduleJob.getCrons().forEach(cron -> new CommandScheduleJob(new JobDataMap((Job)scheduleJob){
                final /* synthetic */ Job val$scheduleJob;
                {
                    this.val$scheduleJob = val$scheduleJob;
                    this.put("job", this.val$scheduleJob);
                }
            }, () -> cron).schedule());
            LogUtil.info("schedule job -> {}", scheduleJob.getName());
        });
    }
}

