/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.fuji.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.gui.PagedGui;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaObjectGui
extends PagedGui<Field> {
    private final String topLevel;
    private final String path;
    private final Object instance;

    public JavaObjectGui(@Nullable SimpleGui parent, Object instance, class_3222 player, @NotNull List<Field> entities, int pageIndex, String topLevel, @NotNull String path) {
        super(parent, player, TextHelper.getTextByKey(player, "object.gui.title", path), entities, pageIndex);
        this.instance = instance;
        this.topLevel = topLevel;
        this.path = path;
        if (this.getEntities().isEmpty()) {
            this.getEntities().addAll(JavaObjectGui.inspectObject(this.instance));
        }
        this.getFooter().setSlot(4, (GuiElementBuilderInterface)GuiHelper.makeHelpButton(player).setLore(List.of(TextHelper.getTextByKey(player, "object.top_level", topLevel))));
    }

    @Override
    protected PagedGui<Field> make(@Nullable SimpleGui parent, class_3222 player, class_2561 title, @NotNull List<Field> entities, int pageIndex) {
        return new JavaObjectGui(this.getParent(), this.instance, player, entities, pageIndex, this.topLevel, this.path);
    }

    private class_1792 computeItem(Field field) {
        return JavaObjectGui.isAtom(field) ? class_1802.field_8407 : class_1802.field_8529;
    }

    private class_2561 computeName(Field field) {
        return class_2561.method_30163((String)field.getName());
    }

    private List<class_2561> computeLore(Field field) {
        Object value;
        try {
            field.setAccessible(true);
            value = field.get(this.instance);
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                value = collection.size() + " entries";
            } else if (value instanceof Map) {
                Map map = (Map)value;
                value = map.size() + " entries";
            }
        }
        catch (Exception e) {
            value = "FAILED-TO-ACCESS";
        }
        class_2561 valueText = TextHelper.getTextByKey(this.getPlayer(), "object.value", new Object[0]);
        String abbreviate = StringUtils.abbreviate((String)value.toString(), (String)"...", (int)128);
        valueText = TextHelper.replaceTextWithMarker(valueText, "value", () -> class_2561.method_43470((String)abbreviate));
        return List.of(TextHelper.getTextByKey(this.getPlayer(), "object.type", field.getType().getSimpleName()), valueText);
    }

    private static boolean isAtom(Field field) {
        Class<?> type = field.getType();
        if (type.isPrimitive()) {
            return true;
        }
        if (ReflectionUtil.isWrapperType(type)) {
            return true;
        }
        if (type.equals(String.class)) {
            return true;
        }
        if (type.isArray()) {
            return true;
        }
        if (type.isEnum()) {
            return true;
        }
        if (type.isAnnotation()) {
            return true;
        }
        if (Iterable.class.isAssignableFrom(type)) {
            return true;
        }
        return Map.class.isAssignableFrom(type);
    }

    private static List<Field> inspectObject(@NotNull Object instance) {
        return Arrays.stream(instance.getClass().getDeclaredFields()).sorted(Comparator.comparing(JavaObjectGui::isAtom)).collect(Collectors.toList());
    }

    @Override
    protected GuiElementInterface toGuiElement(Field entity) {
        return ((GuiElementBuilder)new GuiElementBuilder().setName(this.computeName(entity)).setItem(this.computeItem(entity)).setLore(this.computeLore(entity)).setCallback(() -> {
            if (JavaObjectGui.isAtom(entity)) {
                return;
            }
            try {
                Object newInstance = entity.get(this.instance);
                String newPath = StringUtils.strip((String)(this.path + "." + entity.getName()), (String)".");
                new JavaObjectGui(this.getGui(), newInstance, this.getPlayer(), new ArrayList<Field>(), 0, this.topLevel, newPath).open();
            }
            catch (IllegalAccessException e) {
                LogUtil.error("failed to access the value of field {}", entity, e);
            }
        })).build();
    }

    @Override
    protected List<Field> filter(String keyword) {
        return this.getEntities().stream().filter((? super T it) -> it.getName().contains(keyword)).collect(Collectors.toList());
    }
}

