/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.kit;

import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.core.auxiliary.minecraft.NbtHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandRequirement;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.kit.command.argument.wrapper.KitName;
import io.github.sakurawald.module.initializer.kit.gui.KitEditorGui;
import io.github.sakurawald.module.initializer.kit.structure.Kit;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@CommandNode(value="kit")
@CommandRequirement(level=4)
public class KitInitializer
extends ModuleInitializer {
    private static final String INVENTORY = "inventory";
    private static final Path KIT_DATA_DIR_PATH = ReflectionUtil.computeModuleConfigPath(KitInitializer.class).resolve("kit-data");

    @NotNull
    public static List<String> listKitNames() {
        List<String> list;
        block8: {
            Stream<Path> list2 = Files.list(KIT_DATA_DIR_PATH);
            try {
                list = list2.map(it -> it.toFile().getName()).toList();
                if (list2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (list2 != null) {
                        try {
                            list2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LogUtil.error("failed to list kits in storage.", new Object[0]);
                    return Collections.emptyList();
                }
            }
            list2.close();
        }
        return list;
    }

    @NotNull
    private static List<Kit> readKits() {
        return KitInitializer.listKitNames().stream().map(KitInitializer::readKit).collect(Collectors.toList());
    }

    private static Path computePath(String kitName) {
        return KIT_DATA_DIR_PATH.resolve(kitName);
    }

    public static void deleteKit(@NotNull String kitName) {
        Files.delete(KitInitializer.computePath(kitName));
    }

    public static void writeKit(@NotNull Kit kit) {
        NbtHelper.withNbtFile(KitInitializer.computePath(kit.getName()), root -> {
            class_2499 nbtList = new class_2499();
            NbtHelper.writeSlotsNode(nbtList, kit.getStackList());
            root.method_10566(INVENTORY, (class_2520)nbtList);
        });
    }

    @NotNull
    public static Kit readKit(@NotNull String kitName) {
        List itemStacks = NbtHelper.withNbtFileAndGettingReturnValue(KitInitializer.computePath(kitName), root -> {
            class_2499 nbtList;
            if (root.method_10580(INVENTORY) == null) {
                nbtList = new class_2499();
                root.method_10566(INVENTORY, (class_2520)nbtList);
            }
            nbtList = (class_2499)root.method_10580(INVENTORY);
            return NbtHelper.readSlotsNode(nbtList);
        });
        return new Kit(kitName, itemStacks);
    }

    @CommandNode(value="editor")
    @Document(value="Open the kit editor gui.")
    private static int $editor(@CommandSource class_3222 player) {
        List<Kit> kits = KitInitializer.readKits();
        new KitEditorGui(player, kits, 0).open();
        return 1;
    }

    @CommandNode(value="give")
    @Document(value="Give a kit to a player.")
    private static int $give(@CommandSource class_2168 source, class_3222 player, KitName kit) {
        if (Files.notExists(KitInitializer.computePath((String)kit.getValue()), new LinkOption[0])) {
            TextHelper.sendMessageByKey(source, "kit.kit.empty", new Object[0]);
            return -1;
        }
        Kit $kit = KitInitializer.readKit((String)kit.getValue());
        KitInitializer.insertKit(player, $kit);
        return 1;
    }

    private static void insertKit(class_3222 player, Kit kit) {
        class_1661 playerInventory = player.method_31548();
        ArrayList<class_1799> tryAgainList = new ArrayList<class_1799>();
        for (int i = 0; i < kit.getStackList().size(); ++i) {
            class_1799 template = kit.getStackList().get(i);
            if (template.method_7960()) continue;
            class_1799 copy = template.method_7972();
            if (playerInventory.method_5438(i).method_7960() && playerInventory.method_7367(i, copy)) continue;
            tryAgainList.add(copy);
        }
        tryAgainList.removeIf(arg_0 -> ((class_1661)playerInventory).method_7394(arg_0));
        tryAgainList.forEach(it -> player.method_7328(it, true));
    }

    @Override
    protected void onInitialize() {
        Files.createDirectories(KIT_DATA_DIR_PATH, new FileAttribute[0]);
    }
}

