/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.motd;

import com.google.common.base.Preconditions;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.RandomUtil;
import io.github.sakurawald.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.motd.config.model.MotdConfigModel;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.minecraft.class_2561;
import net.minecraft.class_2926;
import org.jetbrains.annotations.NotNull;

public class MotdInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<MotdConfigModel> config = new ObjectConfigurationHandler<MotdConfigModel>("config.json", MotdConfigModel.class);
    private static final Path ICON_FOLDER = ReflectionUtil.computeModuleConfigPath(MotdInitializer.class).resolve("icon");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static Optional<class_2926.class_8145> getRandomIcon() {
        try {
            Files.createDirectories(ICON_FOLDER, new FileAttribute[0]);
            Stream<Path> list = Files.list(ICON_FOLDER);
            try {
                List<File> icons = list.map(Path::toFile).toList();
                if (icons.isEmpty()) {
                    Optional<class_2926.class_8145> optional = Optional.empty();
                    return optional;
                }
                File randomIcon = RandomUtil.drawList(icons);
                BufferedImage bufferedImage = ImageIO.read(randomIcon);
                Preconditions.checkState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels wide: %s".formatted(randomIcon));
                Preconditions.checkState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels high: %s".formatted(randomIcon));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
                return Optional.of(new class_2926.class_8145(byteArrayOutputStream.toByteArray()));
            }
            finally {
                if (Collections.singletonList(list).get(0) != null) {
                    list.close();
                }
            }
        }
        catch (Exception e) {
            LogUtil.error("failed to encode motd icon.", e);
            return Optional.empty();
        }
    }

    @NotNull
    public static class_2561 getRandomMotdText() {
        List<String> motdList = MotdInitializer.config.model().list;
        String string = motdList.get(new Random().nextInt(motdList.size()));
        return TextHelper.getTextByValue(null, string, new Object[0]);
    }
}

