/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.placeholder.structure;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.regex.Pattern;
import net.minecraft.class_5218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SumUpPlaceholder {
    public static final HashMap<String, SumUpPlaceholder> uuid2stats = new HashMap();
    private static final int CM_TO_KM_DIVISOR = 100000;
    private static final int GT_TO_H_DIVISOR = 72000;
    private static SumUpPlaceholder ofServer;
    public int playtime;
    public int mined;
    public int placed;
    public int killed;
    public int moved;

    private static Path getStatPath() {
        return ServerHelper.getServer().method_27050(class_5218.field_24181);
    }

    public static SumUpPlaceholder ofPlayer(String uuid) {
        if (uuid2stats.containsKey(uuid)) {
            return uuid2stats.get(uuid);
        }
        SumUpPlaceholder ret = new SumUpPlaceholder();
        try {
            int play_time;
            File file = SumUpPlaceholder.getStatPath().resolve(uuid + ".json").toFile();
            if (!file.exists()) {
                return ret;
            }
            JsonElement jsonElement = JsonParser.parseReader((Reader)new FileReader(file));
            if (!jsonElement.isJsonObject()) {
                return new SumUpPlaceholder();
            }
            JsonObject json = jsonElement.getAsJsonObject();
            JsonObject stats = json.getAsJsonObject("stats");
            if (stats == null) {
                return ret;
            }
            int mined_all = SumUpPlaceholder.sumUpStats(stats.getAsJsonObject("minecraft:mined"), ".*");
            int used_all = SumUpPlaceholder.sumUpStats(stats.getAsJsonObject("minecraft:used"), ".*");
            JsonObject custom = stats.getAsJsonObject("minecraft:custom");
            if (custom == null) {
                return ret;
            }
            int moved_all = SumUpPlaceholder.sumUpStats(custom, ".+_cm") / 100000;
            JsonElement mobKills = custom.get("minecraft:mob_kills");
            int mob_kills = mobKills == null ? 0 : mobKills.getAsInt();
            JsonElement playTime = custom.get("minecraft:play_time");
            ret.playtime = play_time = (playTime == null ? 0 : playTime.getAsInt()) / 72000;
            ret.mined = mined_all;
            ret.placed = used_all;
            ret.killed = mob_kills;
            ret.moved = moved_all;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        uuid2stats.put(uuid, ret);
        return ret;
    }

    @NotNull
    public static SumUpPlaceholder ofServer() {
        SumUpPlaceholder ofServer = new SumUpPlaceholder();
        File file = SumUpPlaceholder.getStatPath().toFile();
        File[] files = file.listFiles();
        if (files == null) {
            return ofServer;
        }
        for (File playerStatFile : files) {
            String uuid = playerStatFile.getName().replace(".json", "");
            SumUpPlaceholder playerMainStats = SumUpPlaceholder.ofPlayer(uuid);
            ofServer.plus(playerMainStats);
        }
        SumUpPlaceholder.ofServer = ofServer;
        return ofServer;
    }

    private static int sumUpStats(@Nullable JsonObject jsonObject, @NotNull String regex) {
        if (jsonObject == null) {
            return 0;
        }
        int count = 0;
        Pattern pattern = Pattern.compile(regex);
        for (String key : jsonObject.keySet()) {
            if (!pattern.matcher(key).matches()) continue;
            count += jsonObject.get(key).getAsInt();
        }
        return count;
    }

    public void plus(@NotNull SumUpPlaceholder other) {
        this.playtime += other.playtime;
        this.mined += other.mined;
        this.placed += other.placed;
        this.killed += other.killed;
        this.moved += other.moved;
    }

    public String toString() {
        return "SumUpPlaceholder(playtime=" + this.playtime + ", mined=" + this.mined + ", placed=" + this.placed + ", killed=" + this.killed + ", moved=" + this.moved + ")";
    }

    public static SumUpPlaceholder getOfServer() {
        return ofServer;
    }
}

