/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.skin;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandRequirement;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.command.argument.wrapper.impl.GameProfileCollection;
import io.github.sakurawald.core.command.argument.wrapper.impl.Word;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.core.service.gameprofile_fetcher.MojangProfileFetcher;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.skin.config.model.SkinConfigModel;
import io.github.sakurawald.module.initializer.skin.provider.MineSkinSkinProvider;
import io.github.sakurawald.module.initializer.skin.structure.SkinRestorer;
import io.github.sakurawald.module.initializer.skin.structure.SkinVariant;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import net.minecraft.class_2168;
import org.jetbrains.annotations.NotNull;

@CommandNode(value="skin")
public class SkinInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<SkinConfigModel> config = new ObjectConfigurationHandler<SkinConfigModel>("config.json", SkinConfigModel.class);

    @CommandNode(value="use-default-skins")
    @Document(value="Set skin to a random default skin.")
    private static int useDefault(@CommandSource CommandContext<class_2168> ctx) {
        SkinInitializer.doSkin((class_2168)ctx.getSource(), () -> SkinRestorer.getSkinStorage().getDefaultSkin());
        return 1;
    }

    @CommandNode(value="use-default-skins")
    @Document(value="Set skin to a random default skin.")
    @CommandRequirement(level=4)
    private static int useDefaultOthers(@CommandSource CommandContext<class_2168> ctx, GameProfileCollection target) {
        SkinInitializer.doSkin((class_2168)ctx.getSource(), (Collection)target.getValue(), true, () -> SkinRestorer.getSkinStorage().getDefaultSkin());
        return 1;
    }

    @CommandNode(value="use-online-skin")
    @Document(value="Set skin to an online skin of the same name.")
    private static int useOnlineSkin(@CommandSource CommandContext<class_2168> ctx) {
        SkinInitializer.doSkin((class_2168)ctx.getSource(), () -> MojangProfileFetcher.fetchOnlineSkin(((class_2168)ctx.getSource()).method_9214()));
        return 1;
    }

    @CommandNode(value="set mojang")
    private static int setMojang(@CommandSource CommandContext<class_2168> ctx, Word skinName) {
        SkinInitializer.doSkin((class_2168)ctx.getSource(), () -> MojangProfileFetcher.fetchOnlineSkin((String)skinName.getValue()));
        return 1;
    }

    @CommandNode(value="set mojang")
    @CommandRequirement(level=4)
    @Document(value="Set skin to an online skin of a specified name.")
    private static int setMojangTarget(@CommandSource CommandContext<class_2168> ctx, Word skinName, GameProfileCollection target) {
        SkinInitializer.doSkin((class_2168)ctx.getSource(), (Collection)target.getValue(), true, () -> MojangProfileFetcher.fetchOnlineSkin((String)skinName.getValue()));
        return 1;
    }

    @CommandNode(value="set web classic")
    @Document(value="Set skin to a custom url in steve model.")
    private static int setWebClassic(@CommandSource CommandContext<class_2168> ctx, String url) {
        SkinInitializer.doSkin((class_2168)ctx.getSource(), () -> MineSkinSkinProvider.fetchSkin(url, SkinVariant.CLASSIC));
        return 1;
    }

    @CommandNode(value="set web classic")
    @CommandRequirement(level=4)
    @Document(value="Set skin to a custom url in steve model.")
    private static int setWebClassicOthers(@CommandSource CommandContext<class_2168> ctx, String url, GameProfileCollection target) {
        SkinInitializer.doSkin((class_2168)ctx.getSource(), (Collection)target.getValue(), true, () -> MineSkinSkinProvider.fetchSkin(StringArgumentType.getString((CommandContext)ctx, (String)"url"), SkinVariant.CLASSIC));
        return 1;
    }

    @CommandNode(value="set web slim")
    @Document(value="Set skin to a custom url in alex model.")
    private static int setWebSlim(@CommandSource CommandContext<class_2168> ctx, String url) {
        SkinInitializer.doSkin((class_2168)ctx.getSource(), () -> MineSkinSkinProvider.fetchSkin(url, SkinVariant.SLIM));
        return 1;
    }

    @CommandNode(value="set web slim")
    @CommandRequirement(level=4)
    @Document(value="Set skin to a custom url in alex model.")
    private static int setWebSlimOthers(@CommandSource CommandContext<class_2168> ctx, String url, GameProfileCollection target) {
        SkinInitializer.doSkin((class_2168)ctx.getSource(), (Collection)target.getValue(), true, () -> MineSkinSkinProvider.fetchSkin(StringArgumentType.getString((CommandContext)ctx, (String)"url"), SkinVariant.SLIM));
        return 1;
    }

    private static int doSkin(@NotNull class_2168 src, @NotNull Collection<GameProfile> targets, boolean setByOperator, @NotNull Supplier<Property> skinSupplier) {
        SkinRestorer.setSkinAsync(src.method_9211(), targets, skinSupplier).thenAccept(pair -> {
            Collection players = (Collection)pair.left();
            Collection profiles = (Collection)pair.right();
            if (profiles.isEmpty()) {
                TextHelper.sendMessageByKey(src, "skin.action.failed", new Object[0]);
                return;
            }
            if (setByOperator) {
                TextHelper.sendMessageByKey(src, "skin.action.affected_profile", String.join((CharSequence)", ", profiles.stream().map(GameProfile::getName).toList()));
                if (!players.isEmpty()) {
                    TextHelper.sendMessageByKey(src, "skin.action.affected_player", String.join((CharSequence)", ", players.stream().map(p -> p.method_7334().getName()).toList()));
                }
            } else {
                TextHelper.sendMessageByKey(src, "skin.action.ok", new Object[0]);
            }
        });
        return targets.size();
    }

    private static int doSkin(@NotNull class_2168 src, @NotNull Supplier<Property> skinSupplier) {
        if (src.method_44023() == null) {
            return -1;
        }
        return SkinInitializer.doSkin(src, Collections.singleton(src.method_44023().method_7334()), false, skinSupplier);
    }
}

