/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.tpa;

import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.core.job.impl.MentionPlayersJob;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.tpa.config.model.TpaConfigModel;
import io.github.sakurawald.module.initializer.tpa.structure.TpaRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class TpaInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<TpaConfigModel> config = new ObjectConfigurationHandler<TpaConfigModel>("config.json", TpaConfigModel.class);
    private static final List<TpaRequest> requests = new ArrayList<TpaRequest>();

    @CommandNode(value="tpa")
    private static int $tpa(@CommandSource class_3222 player, class_3222 target) {
        return TpaInitializer.doRequest(player, target, false);
    }

    @CommandNode(value="tpahere")
    private static int $tpahere(@CommandSource class_3222 player, class_3222 target) {
        return TpaInitializer.doRequest(player, target, true);
    }

    @CommandNode(value="tpaaccept")
    private static int $tpaaccept(@CommandSource class_3222 player, class_3222 target) {
        return TpaInitializer.doResponse(player, target, ResponseStatus.ACCEPT);
    }

    private static void doResponseToAll(class_3222 me, ResponseStatus responseStatus) {
        ArrayList targetPlayers = requests.stream().filter(request -> {
            if (responseStatus == ResponseStatus.CANCEL) {
                return request.getSender().equals((Object)me);
            }
            return request.getReceiver().equals((Object)me);
        }).collect(Collectors.toCollection(ArrayList::new));
        targetPlayers.forEach(request -> {
            class_3222 responseTarget = responseStatus == ResponseStatus.CANCEL ? request.getReceiver() : request.getSender();
            TpaInitializer.doResponse(me, responseTarget, responseStatus);
        });
    }

    @CommandNode(value="tpaaccept all")
    private static int $tpaaccept(@CommandSource class_3222 player) {
        TpaInitializer.doResponseToAll(player, ResponseStatus.ACCEPT);
        return 1;
    }

    @CommandNode(value="tpadeny")
    private static int $tpadeny(@CommandSource class_3222 player, class_3222 target) {
        return TpaInitializer.doResponse(player, target, ResponseStatus.DENY);
    }

    @CommandNode(value="tpadeny all")
    private static int $tpadeny(@CommandSource class_3222 player) {
        TpaInitializer.doResponseToAll(player, ResponseStatus.DENY);
        return 1;
    }

    @CommandNode(value="tpacancel")
    private static int $tpacancel(@CommandSource class_3222 player, class_3222 target) {
        return TpaInitializer.doResponse(player, target, ResponseStatus.CANCEL);
    }

    @CommandNode(value="tpacancel all")
    private static int $tpacancel(@CommandSource class_3222 player) {
        TpaInitializer.doResponseToAll(player, ResponseStatus.CANCEL);
        return 1;
    }

    private static int doResponse(class_3222 player, class_3222 target, ResponseStatus status) {
        Optional<TpaRequest> requestOptional = requests.stream().filter(request -> status == ResponseStatus.CANCEL ? request.getSender().equals((Object)player) && request.getReceiver().equals((Object)target) : request.getSender().equals((Object)target) && request.getReceiver().equals((Object)player)).findFirst();
        if (requestOptional.isEmpty()) {
            TextHelper.sendActionBarByKey(player, "tpa.no_relative_ticket", new Object[0]);
            return -1;
        }
        TpaRequest request2 = requestOptional.get();
        if (status == ResponseStatus.ACCEPT) {
            request2.getSender().method_7353((class_2561)request2.asSenderText$Accepted(), true);
            class_3222 who = request2.getTeleportWho();
            class_3222 to = request2.getTeleportTo();
            MentionPlayersJob.requestJob(TpaInitializer.config.model().mention_player, request2.isTpahere() ? to : who);
            who.method_14251((class_3218)to.method_37908(), to.method_23317(), to.method_23318(), to.method_23321(), to.method_36454(), to.method_36455());
        } else if (status == ResponseStatus.DENY) {
            request2.getSender().method_7353((class_2561)request2.asSenderText$Denied(), true);
            request2.getReceiver().method_43496((class_2561)request2.asReceiverText$Denied());
        } else if (status == ResponseStatus.CANCEL) {
            request2.getSender().method_43496((class_2561)request2.asSenderText$Cancelled());
            request2.getReceiver().method_43496((class_2561)request2.asReceiverText$Cancelled());
        }
        request2.cancelTimeout();
        requests.remove(request2);
        return 1;
    }

    private static int doRequest(class_3222 source, class_3222 target, boolean tpahere) {
        TpaRequest request = new TpaRequest(source, target, tpahere);
        if (request.getSender().equals((Object)request.getReceiver())) {
            TextHelper.sendActionBarByKey(request.getSender(), "tpa.request_to_self", new Object[0]);
            return -1;
        }
        if (requests.stream().anyMatch(request::similarTo)) {
            TextHelper.sendActionBarByKey(request.getSender(), "tpa.similar_request_exists", new Object[0]);
            return -1;
        }
        requests.add(request);
        request.startTimeout();
        request.getReceiver().method_43496((class_2561)request.asReceiverText$Sent());
        MentionPlayersJob.requestJob(TpaInitializer.config.model().mention_player, request.getReceiver());
        request.getSender().method_43496((class_2561)request.asSenderText$Sent());
        return 1;
    }

    public static List<TpaRequest> getRequests() {
        return requests;
    }

    private static enum ResponseStatus {
        ACCEPT,
        DENY,
        CANCEL;

    }
}

