/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.world;

import com.google.common.collect.ImmutableList;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.event.impl.ServerTickEvents;
import io.github.sakurawald.core.event.impl.ServerWorldEvents;
import io.github.sakurawald.core.extension.SimpleRegistryExtension;
import io.github.sakurawald.core.manager.Managers;
import io.github.sakurawald.core.structure.SpatialPose;
import io.github.sakurawald.core.structure.TeleportTicket;
import io.github.sakurawald.module.initializer.world.accessor.IDimensionOptions;
import io.github.sakurawald.module.initializer.world.structure.DimensionNode;
import io.github.sakurawald.module.initializer.world.structure.MyServerWorld;
import io.github.sakurawald.module.initializer.world.structure.MyWorldProperties;
import io.github.sakurawald.module.initializer.world.structure.VoidWorldGenerationProgressListener;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2881;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4543;
import net.minecraft.class_5268;
import net.minecraft.class_5304;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_7134;
import net.minecraft.class_7924;
import net.minecraft.class_9248;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class WorldManager {
    private static final Set<class_3218> deletionQueue = new ReferenceOpenHashSet();
    private static final Set<DimensionNode> creationQueue = new ReferenceOpenHashSet();

    public static void requestToDeleteWorld(@NotNull class_3218 world) {
        MinecraftServer server = world.method_8503();
        server.method_20493(() -> deletionQueue.add(world));
    }

    public static void requestToCreateWorld(DimensionNode dimensionNode) {
        ServerHelper.getServer().method_20493(() -> creationQueue.add(dimensionNode));
    }

    private static void tick() {
        if (!deletionQueue.isEmpty()) {
            deletionQueue.removeIf(WorldManager::tryDeleteWorld);
        }
        if (!creationQueue.isEmpty()) {
            creationQueue.removeIf(WorldManager::tryCreateWorld);
        }
    }

    private static boolean tryCreateWorld(@NotNull DimensionNode dimensionNode) {
        if (deletionQueue.stream().anyMatch(it -> RegistryHelper.ofString((class_1937)it).equals(dimensionNode.getDimension()))) {
            return false;
        }
        MinecraftServer server = ServerHelper.getServer();
        class_2960 dimension = class_2960.method_60654((String)dimensionNode.getDimension());
        class_2960 dimensionType = class_2960.method_60654((String)dimensionNode.getDimension_type());
        long seed = dimensionNode.getSeed();
        WorldManager.registerWorld(server, dimension, dimensionType, seed);
        return true;
    }

    private static boolean tryDeleteWorld(@NotNull class_3218 world) {
        if (world.method_18456().isEmpty()) {
            WorldManager.deleteWorld(world);
            return true;
        }
        WorldManager.kickPlayers(world);
        return false;
    }

    private static void kickPlayers(@NotNull class_3218 world) {
        if (world.method_18456().isEmpty()) {
            return;
        }
        class_3218 overworld = world.method_8503().method_30002();
        class_2338 spawnPos = overworld.method_43126();
        ArrayList players = new ArrayList(world.method_18456());
        for (class_3222 player : players) {
            SpatialPose from = SpatialPose.of(player);
            SpatialPose to = new SpatialPose((class_1937)overworld, (double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264() + 0.5, (double)spawnPos.method_10260() + 0.5, 0.0f, 0.0f);
            TeleportTicket teleportTicket = TeleportTicket.makeVipTicket(player, from, to);
            Managers.getBossBarManager().addTicket(teleportTicket);
        }
    }

    private static void deleteWorld(@NotNull class_3218 world) {
        MinecraftServer server = world.method_8503();
        class_5321 dimensionKey = world.method_27983();
        if (server.field_4589.remove(dimensionKey, world)) {
            ServerWorldEvents.UNLOAD.invoker().fire(server, world);
            class_2370 dimensionsRegistry = (class_2370)RegistryHelper.ofRegistry(class_7924.field_41224);
            SimpleRegistryExtension.remove(dimensionsRegistry, dimensionKey.method_29177());
            File worldDirectory = server.field_23784.method_27424(dimensionKey).toFile();
            WorldManager.deleteFiles(worldDirectory);
        }
    }

    private static void deleteFiles(@NotNull File file) {
        if (file.exists() && file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            for (File child : files) {
                if (child.isDirectory()) {
                    WorldManager.deleteFiles(child);
                    continue;
                }
                child.delete();
            }
        }
    }

    @NotNull
    private static class_5363 makeDimensionOptions(@NotNull class_2378<class_5363> registry, class_2960 dimensionTypeIdentifier) {
        class_5363 template = (class_5363)registry.method_10223(dimensionTypeIdentifier);
        if (template == null) {
            throw new IllegalArgumentException("The dimension type %s can't be used as template.".formatted(dimensionTypeIdentifier));
        }
        return new class_5363(template.comp_1012(), template.comp_1013());
    }

    private static void registerWorld(@NotNull MinecraftServer server, class_2960 dimensionIdentifier, @NotNull class_2960 dimenstionTypeIdentifier, long seed) {
        MyServerWorld world;
        MyWorldProperties worldProperties = new MyWorldProperties(server.method_27728(), seed);
        class_5321 worldRegistryKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)dimensionIdentifier);
        LogUtil.debug("make instance of world with registry key of type `World`: {}", worldRegistryKey);
        class_2378 registry = RegistryHelper.ofRegistry(class_7924.field_41224);
        class_5363 dimensionOptions = WorldManager.makeDimensionOptions(registry, dimenstionTypeIdentifier);
        ((IDimensionOptions)dimensionOptions).fuji$setSaveProperties(false);
        try {
            world = new MyServerWorld(server, class_156.method_18349(), server.field_23784, (class_5268)worldProperties, (class_5321<class_1937>)worldRegistryKey, dimensionOptions, VoidWorldGenerationProgressListener.INSTANCE, false, class_4543.method_27984((long)seed), (List<class_5304>)ImmutableList.of(), true, null);
        }
        catch (Exception e) {
            LogUtil.error("failed to make ServerWorld instance: dimensionId = {}, dimensionTypeId = {}", dimensionIdentifier, dimenstionTypeIdentifier, e);
            return;
        }
        if (dimenstionTypeIdentifier.equals((Object)class_7134.field_37672)) {
            world.method_51837(new class_2881((class_3218)world, world.method_8412(), class_2881.class_8576.field_44946));
        }
        class_2370 dimensionOptionsRegistry = (class_2370)RegistryHelper.ofRegistry(class_7924.field_41224);
        boolean original = ((SimpleRegistryExtension)dimensionOptionsRegistry).fuji$isFrozen();
        ((SimpleRegistryExtension)dimensionOptionsRegistry).fuji$setFrozen(false);
        class_5321 dimensionOptionsRegistryKey = class_7924.method_47518((class_5321)worldRegistryKey);
        if (!dimensionOptionsRegistry.method_35842(dimensionOptionsRegistryKey)) {
            LogUtil.debug("add entry for dimension options registry: key = {}, value = {}", dimensionOptionsRegistryKey, dimensionOptions);
            dimensionOptionsRegistry.method_10272(dimensionOptionsRegistryKey, (Object)dimensionOptions, class_9248.field_49136);
        }
        ((SimpleRegistryExtension)dimensionOptionsRegistry).fuji$setFrozen(original);
        server.field_4589.put(world.method_27983(), world);
        ServerWorldEvents.LOAD.invoker().fire(server, world);
        world.method_18765(() -> true);
    }

    static {
        ServerTickEvents.START_SERVER_TICK.register(server -> WorldManager.tick());
    }
}

