/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.mixin.command_attachment;

import io.github.sakurawald.core.auxiliary.minecraft.UuidHelper;
import io.github.sakurawald.module.initializer.command_attachment.CommandAttachmentInitializer;
import io.github.sakurawald.module.initializer.command_attachment.command.argument.wrapper.InteractType;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_3965;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3225.class})
public class ServerPlayerInteractionManagerMixin {
    @Shadow
    @Final
    protected class_3222 field_14008;

    @Inject(method={"interactItem"}, at={@At(value="HEAD")})
    void onPlayerRightClick(class_3222 serverPlayerEntity, class_1937 world, @NotNull class_1799 itemStack, class_1268 hand, @NotNull CallbackInfoReturnable<class_1269> cir) {
        String uuid = UuidHelper.getAttachedUuid((class_9279)itemStack.method_57824(class_9334.field_49628));
        if (uuid == null) {
            return;
        }
        CommandAttachmentInitializer.triggerAttachmentModel(uuid, (class_1657)this.field_14008, List.of(InteractType.RIGHT, InteractType.BOTH));
    }

    @Inject(method={"onBlockBreakingAction"}, at={@At(value="HEAD")})
    void onPlayerLeftClickBlock(class_2338 blockPos, boolean bl, int i, String string, CallbackInfo ci) {
        if (string.equals("actual start of destroying")) {
            String uuid = UuidHelper.getAttachedUuid((class_1937)this.field_14008.method_51469(), blockPos);
            if (!CommandAttachmentInitializer.existsAttachmentModel(uuid)) {
                return;
            }
            CommandAttachmentInitializer.triggerAttachmentModel(uuid, (class_1657)this.field_14008, List.of(InteractType.LEFT, InteractType.BOTH));
        }
    }

    @Inject(method={"interactBlock"}, at={@At(value="HEAD")}, cancellable=true)
    void onPlayerRightClickBlock(class_3222 serverPlayerEntity, @NotNull class_1937 world, class_1799 itemStack, class_1268 hand, @NotNull class_3965 blockHitResult, @NotNull CallbackInfoReturnable<class_1269> cir) {
        if (hand == class_1268.field_5808) {
            String uuid = UuidHelper.getAttachedUuid(world, blockHitResult.method_17777());
            if (!CommandAttachmentInitializer.existsAttachmentModel(uuid)) {
                return;
            }
            CommandAttachmentInitializer.triggerAttachmentModel(uuid, (class_1657)this.field_14008, List.of(InteractType.RIGHT, InteractType.BOTH));
            cir.setReturnValue((Object)class_1269.field_5814);
        }
    }
}

