/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.mixin.core.event;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.sakurawald.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.core.event.impl.ServerTickEvents;
import io.github.sakurawald.core.event.impl.ServerWorldEvents;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={MinecraftServer.class})
public class MinecraftServerMixin {
    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;setupServer()Z")}, method={"runServer"})
    private void beforeSetupServer(CallbackInfo info) {
        ServerLifecycleEvents.SERVER_STARTING.invoker().fire((MinecraftServer)this);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;createMetadata()Lnet/minecraft/server/ServerMetadata;", ordinal=0)}, method={"runServer"})
    private void afterSetupServer(CallbackInfo info) {
        ServerLifecycleEvents.SERVER_STARTED.invoker().fire((MinecraftServer)this);
    }

    @Inject(at={@At(value="TAIL")}, method={"shutdown"})
    private void afterShutdownServer(CallbackInfo info) {
        ServerLifecycleEvents.SERVER_STOPPED.invoker().fire((MinecraftServer)this);
    }

    @Inject(at={@At(value="HEAD")}, method={"shutdown"})
    private void beforeShutdownServer(CallbackInfo info) {
        ServerLifecycleEvents.SERVER_STOPPING.invoker().fire((MinecraftServer)this);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;tickWorlds(Ljava/util/function/BooleanSupplier;)V")}, method={"tick"})
    private void onStartTick(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        ServerTickEvents.START_SERVER_TICK.invoker().fire((MinecraftServer)this);
    }

    @WrapOperation(method={"createWorlds"}, at={@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;")})
    private <K, V> V onLoadWorld(Map<K, V> worlds, K registryKey, V serverWorld, Operation<V> original) {
        Object result = original.call(new Object[]{worlds, registryKey, serverWorld});
        ServerWorldEvents.LOAD.invoker().fire((MinecraftServer)this, (class_3218)serverWorld);
        return (V)result;
    }

    @Inject(method={"shutdown"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;close()V")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void onUnloadWorldAtShutdown(CallbackInfo ci, Iterator<class_3218> worlds, class_3218 world) {
        ServerWorldEvents.UNLOAD.invoker().fire((MinecraftServer)this, world);
    }
}

