/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.auxiliary;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import mod.fuji.Fuji;
import mod.fuji.core.annotation.CallerSensitive;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.config.mapper.GsonMapper;
import mod.fuji.core.event.graph.EventGraph;
import mod.fuji.core.module.ModulePathResolver;
import org.jetbrains.annotations.NotNull;

public class ReflectionUtil {
    @NotNull
    public static String getEnumValuesCompactString(@NotNull Class<?> enumClass) {
        ?[] enumConstants = enumClass.getEnumConstants();
        return Arrays.stream(enumConstants).map(Object::toString).collect(Collectors.joining(", "));
    }

    public static boolean canInspectInside(@NotNull Class<?> objectType) {
        if (objectType.isPrimitive()) {
            return false;
        }
        if (ReflectionUtil.isPrimitiveWrapperType(objectType)) {
            return false;
        }
        if (objectType.equals(String.class)) {
            return false;
        }
        if (objectType.isArray()) {
            return false;
        }
        if (objectType.isEnum()) {
            return false;
        }
        if (objectType.isAnnotation()) {
            return false;
        }
        return !ReflectionUtil.isMetaClass(objectType);
    }

    public static boolean isMetaClass(@NotNull Class<?> clazz) {
        return clazz == Class.class || clazz == Method.class || clazz == Field.class || clazz == Constructor.class || clazz == Parameter.class;
    }

    public static List<Method> getMethodsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        return Arrays.stream(clazz.getDeclaredMethods()).filter(it -> it.isAnnotationPresent(annotation)).toList();
    }

    public static Path computeModuleConfigPath(Class<?> clazz) {
        String modulePath = ModulePathResolver.computeModulePathString(clazz.getName());
        return ReflectionUtil.computeModuleConfigPath(modulePath);
    }

    public static Path computeModuleConfigPath(String modulePath) {
        String others = modulePath.replace(".", "/");
        return Fuji.MOD_CONFIG_PATH.resolve("modules").resolve(others);
    }

    public static boolean isPrimitiveWrapperType(Type type) {
        return type == Integer.class || type == Float.class || type == Byte.class || type == Double.class || type == Long.class || type == Character.class || type == Boolean.class || type == Short.class || type == Void.class;
    }

    public static List<String> extractStackTraceElements(Throwable throwable) {
        return Arrays.stream(throwable.getStackTrace()).map(StackTraceElement::toString).toList();
    }

    @NotNull
    public static String getSimpleClassName(Class<?> clazz) {
        String simpleClassName = clazz.getSimpleName();
        if (simpleClassName.isBlank()) {
            simpleClassName = "ANONYMOUS-CLASS";
        }
        return simpleClassName;
    }

    public static class Stacktrace {
        @CallerSensitive
        public static String findSourceModuleInCurrentStackTrace() {
            return Stacktrace.findSourceModuleAsJoinedModulePath(Stacktrace.getCurrentStackTraceAsModuleName());
        }

        @CallerSensitive
        private static String findSourceModuleAsJoinedModulePath(List<String> joinedModulePathList) {
            String result = "unknown";
            for (String splitModulePath : joinedModulePathList) {
                result = splitModulePath;
                if (result.equals("core")) continue;
                return result;
            }
            return result;
        }

        @CallerSensitive
        private static List<String> getCurrentStackTraceAsClassNames() {
            return Arrays.stream(Thread.currentThread().getStackTrace()).map(StackTraceElement::getClassName).toList();
        }

        @CallerSensitive
        private static List<String> getCurrentStackTraceAsModuleName() {
            return Stacktrace.getCurrentStackTraceAsClassNames().stream().map(ModulePathResolver::computeModulePathString).toList();
        }

        @CallerSensitive
        public static StackTraceElement getCallerMethod() {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            return stackTrace[3];
        }
    }

    public static class Reflection {
        @NotNull
        public static Field getInstanceField(@NotNull Object instance, @NotNull String fieldName) {
            Field field = Reflection.gatherDeclaredFields(instance.getClass()).stream().filter(it -> it.getName().equals(fieldName)).findFirst().orElseThrow();
            field.setAccessible(true);
            return field;
        }

        @NotNull
        public static <T> T getInstanceFieldValue(@NotNull Object instance, @NotNull String fieldName, @NotNull Class<T> clazz) {
            Field field = Reflection.getInstanceField(instance, fieldName);
            Object fieldValue = field.get(instance);
            if (!clazz.isInstance(fieldValue)) {
                throw new IllegalArgumentException("The returned instance field value can't be casted to the expected type %s. (instance = %s, declaredFieldName = %s)".formatted(clazz.getName(), instance, fieldName));
            }
            return clazz.cast(fieldValue);
        }

        public static void setInstanceFieldValue(@NotNull Object instance, @NotNull String declaredFieldName, @NotNull Object fieldValue) {
            Field field = Reflection.getInstanceField(instance, declaredFieldName);
            field.set(instance, fieldValue);
        }

        private static void gatherDeclaredFieldsRecursively(List<Field> result, Class<?> clazz) {
            Field[] declaredFields = clazz.getDeclaredFields();
            result.addAll(Arrays.asList(declaredFields));
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != Object.class) {
                Reflection.gatherDeclaredFieldsRecursively(result, superclass);
            }
        }

        public static List<Field> gatherDeclaredFields(Class<?> clazz) {
            ArrayList<Field> allDeclaredFields = new ArrayList<Field>();
            Reflection.gatherDeclaredFieldsRecursively(allDeclaredFields, clazz);
            return allDeclaredFields;
        }
    }

    public static class CompileTimeGraph {
        public static final String GRAPH_DIRECTORY_NAME = "graph";
        private static final String GRAPH_CLASSPATH_PREFIX = "/graph/";
        public static final String MODULE_INITIALIZER_GRAPH_FILE_NAME = "module-initializer-graph.txt";
        public static final String ARGUMENT_TYPE_ADAPTER_GRAPH_FILE_NAME = "argument-type-adapter-graph.txt";
        public static final String EVENT_GRAPH_FILE_NAME = "event-graph.json";
        public static final String LANGUAGE_GRAPH_FILE_NAME = "language-graph.txt";
        public static final String MODULE_GRAPH_FILE_NAME = "module-graph.txt";
        private static final AtomicReference<Object> eventGraph = new AtomicReference();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static List<String> getCompileTimeTxtGraph(@NotNull String graphName) {
            ArrayList<String> arrayList;
            block7: {
                InputStream virtualInputStream = CompileTimeGraph.getVirtualJarInputStream(graphName);
                BufferedReader reader = new BufferedReader(new InputStreamReader(virtualInputStream, StandardCharsets.UTF_8));
                try {
                    String line;
                    ArrayList<String> lines = new ArrayList<String>();
                    while ((line = reader.readLine()) != null) {
                        lines.add(line);
                    }
                    arrayList = lines;
                    if (Collections.singletonList(reader).get(0) == null) break block7;
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(reader).get(0) != null) {
                        reader.close();
                    }
                    throw throwable;
                }
                reader.close();
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static <T> T getCompileTimeJsonGraph(@NotNull String graphName, @NotNull Class<T> clazz) {
            InputStream virtualInputStream = CompileTimeGraph.getVirtualJarInputStream(graphName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(virtualInputStream, StandardCharsets.UTF_8));
            try {
                T t = GsonMapper.fromJson(reader, clazz);
                return t;
            }
            finally {
                if (Collections.singletonList(reader).get(0) != null) {
                    reader.close();
                }
            }
        }

        @NotNull
        private static InputStream getVirtualJarInputStream(@NotNull String graphName) {
            String graphPath = GRAPH_CLASSPATH_PREFIX + graphName;
            InputStream virtualInputStream = ReflectionUtil.class.getResourceAsStream(graphPath);
            if (virtualInputStream == null) {
                LogUtil.error("Failed to load the graph {} from virtual jar file. Is the jar file damaged?", graphName);
                throw new RuntimeException("Failed to load the graph " + graphName);
            }
            return virtualInputStream;
        }

        @NotNull
        private static EventGraph makeEventGraph() {
            return CompileTimeGraph.getCompileTimeJsonGraph(EVENT_GRAPH_FILE_NAME, EventGraph.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public static EventGraph getEventGraph() {
            Object $value = eventGraph.get();
            if ($value == null) {
                AtomicReference<Object> atomicReference = eventGraph;
                synchronized (atomicReference) {
                    $value = eventGraph.get();
                    if ($value == null) {
                        EventGraph actualValue = CompileTimeGraph.makeEventGraph();
                        $value = actualValue == null ? eventGraph : actualValue;
                        eventGraph.set($value);
                    }
                }
            }
            return (EventGraph)($value == eventGraph ? null : $value);
        }
    }
}

