/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.service.cache.service;

import com.mojang.authlib.GameProfile;
import java.time.Duration;
import java.util.function.Supplier;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.config.mapper.wrapper.GameProfileWrapper;
import mod.fuji.core.service.cache.CacheManager;
import mod.fuji.core.service.gameprofile_fetcher.MojangProfileFetcher;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class GameProfileCacheService {
    private static final String GAME_PROFILE_CACHE_KEY = "game_profile";

    public static void setGameProfileCache(@NotNull class_3222 player) {
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        GameProfileWrapper cachedGameProfile = GameProfileCacheService.getCachedGameProfile(player);
        LogUtil.debug("Set game profile cache for player {}. (cache = {})", playerName, cachedGameProfile);
    }

    @NotNull
    public static GameProfileWrapper getCachedGameProfile(@NotNull String onlinePlayerName) {
        return GameProfileCacheService.getCachedGameProfile(onlinePlayerName, Duration.ofDays(7L), () -> GameProfileCacheService.supplyOnlineGameProfile(onlinePlayerName));
    }

    @NotNull
    public static GameProfileWrapper getCachedGameProfile(@NotNull class_3222 player) {
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        return GameProfileCacheService.getCachedGameProfile(playerName, Duration.ofMillis(0L), () -> GameProfileCacheService.supplyOfflineGameProfile(player));
    }

    @NotNull
    private static GameProfileWrapper getCachedGameProfile(@NotNull String onlinePlayerName, @NotNull Duration expirationDuration, @NotNull Supplier<GameProfileWrapper> supplier) {
        return CacheManager.getCachedValueOrCompute(GAME_PROFILE_CACHE_KEY, onlinePlayerName, GameProfileWrapper.class, expirationDuration, supplier);
    }

    @NotNull
    private static GameProfileWrapper supplyOfflineGameProfile(@NotNull class_3222 serverPlayerEntity) {
        return GameProfileWrapper.fromVanillaType(serverPlayerEntity.method_7334());
    }

    @NotNull
    private static GameProfileWrapper supplyOnlineGameProfile(@NotNull String onlinePlayerName) {
        return MojangProfileFetcher.fetchOnlinePlayerUUID(onlinePlayerName).map(uuid -> {
            GameProfile gameProfile = new GameProfile(uuid, onlinePlayerName);
            return MojangProfileFetcher.fetchOnlineGameProfile(onlinePlayerName).map(GameProfileWrapper::fromVanillaType).orElseGet(() -> GameProfileWrapper.fromVanillaType(gameProfile));
        }).orElseGet(() -> GameProfileWrapper.of(null, onlinePlayerName));
    }
}

