/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.service.backup;

import java.io.File;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import mod.fuji.Fuji;
import mod.fuji.core.auxiliary.ChronosUtil;
import mod.fuji.core.auxiliary.IOUtil;
import mod.fuji.core.lifecycle.interfaces.ModSubInitializer;
import org.jetbrains.annotations.NotNull;

public abstract class BaseBackupManager
implements ModSubInitializer {
    protected final Path BACKUP_STORAGE_PATH;

    public BaseBackupManager(Path BACKUP_STORAGE_PATH) {
        this.BACKUP_STORAGE_PATH = BACKUP_STORAGE_PATH;
    }

    @Override
    public void onInitialize() {
        Files.createDirectories(this.BACKUP_STORAGE_PATH, new FileAttribute[0]);
        this.createBackup();
    }

    protected abstract boolean shouldSkipPath(@NotNull Path var1);

    @NotNull
    protected List<File> getInputFiles() {
        final ArrayList<File> files = new ArrayList<File>();
        Files.walkFileTree(Fuji.MOD_CONFIG_PATH, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            @NotNull
            public FileVisitResult preVisitDirectory(@NotNull Path dir, BasicFileAttributes attrs) {
                if (BaseBackupManager.this.BACKUP_STORAGE_PATH.equals(dir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (BaseBackupManager.this.shouldSkipPath(dir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, BasicFileAttributes attrs) {
                files.add(file.toFile());
                return FileVisitResult.CONTINUE;
            }
        });
        return files;
    }

    @NotNull
    protected File getOutputFile() {
        Object fileName = ChronosUtil.Formatter.getFormattedCurrentDate() + ".zip";
        fileName = IOUtil.makeValidWindowsFileName((String)fileName);
        return this.BACKUP_STORAGE_PATH.resolve((String)fileName).toFile();
    }

    public void createBackup() {
        IOUtil.Compressor.compressFiles(Fuji.MOD_CONFIG_PATH.toFile(), this.getInputFiles(), this.getOutputFile());
    }
}

