/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.leaderboard.structure;

import java.time.ZonedDateTime;
import java.util.List;
import lombok.Generated;
import mod.fuji.core.auxiliary.ChronosUtil;
import mod.fuji.module.initializer.leaderboard.service.LeaderBoardService;
import mod.fuji.module.initializer.leaderboard.structure.LeaderBoardSnapshot;
import mod.fuji.module.initializer.leaderboard.structure.LeaderBoardTimeWindow;
import org.jetbrains.annotations.NotNull;

public class LeaderBoardCache {
    @NotNull
    private String playerName;
    @NotNull
    private List<LeaderBoardSnapshot> snapshots = LeaderBoardSnapshot.makeDefaultList();

    public static LeaderBoardCache of(String playerName) {
        return new LeaderBoardCache(playerName, LeaderBoardSnapshot.makeDefaultList());
    }

    public LeaderBoardSnapshot getSnapshot(@NotNull LeaderBoardTimeWindow timeWindow) {
        return this.snapshots.stream().filter(it -> it.getTimeWindow().equals((Object)timeWindow)).findFirst().orElseGet(() -> {
            LeaderBoardSnapshot newValue = LeaderBoardSnapshot.of(timeWindow);
            this.snapshots.add(newValue);
            return newValue;
        });
    }

    public void updateSnapshots(long updateTime, int newScore) {
        ZonedDateTime now = ChronosUtil.getZonedDateTime();
        this.updateSnapshot(newScore, LeaderBoardTimeWindow.HOURLY, ChronosUtil.toTimestamp(ChronosUtil.Boundary.getBeginningOfCurrentHour(now)));
        this.updateSnapshot(newScore, LeaderBoardTimeWindow.DAILY, ChronosUtil.toTimestamp(ChronosUtil.Boundary.getBeginningOfTheDay(now)));
        this.updateSnapshot(newScore, LeaderBoardTimeWindow.WEEKLY, ChronosUtil.toTimestamp(ChronosUtil.Boundary.getBeginningOfCurrentWeek(now, LeaderBoardService.getBeginningOfTheWeek())));
        this.updateSnapshot(newScore, LeaderBoardTimeWindow.MONTHLY, ChronosUtil.toTimestamp(ChronosUtil.Boundary.getBeginningOfCurrentMonth(now)));
        this.updateSnapshot(newScore, LeaderBoardTimeWindow.YEARLY, ChronosUtil.toTimestamp(ChronosUtil.Boundary.getBeginningOfCurrentYear(now)));
        this.updateSnapshot(newScore, LeaderBoardTimeWindow.ALL_TIME, 0L);
    }

    private void updateSnapshot(int newScore, @NotNull LeaderBoardTimeWindow timeWindow, long beginningOfCurrentTimeWindow) {
        LeaderBoardSnapshot snapshot = this.getSnapshot(timeWindow);
        snapshot.setCurrentScore(newScore);
        if (snapshot.getBeginningOfCurrentTimeWindow() == null) {
            snapshot.setBeginningOfCurrentTimeWindow(beginningOfCurrentTimeWindow);
            snapshot.setPreviousScore(0);
        } else if (beginningOfCurrentTimeWindow != snapshot.getBeginningOfCurrentTimeWindow()) {
            snapshot.setBeginningOfCurrentTimeWindow(beginningOfCurrentTimeWindow);
            snapshot.setPreviousScore(snapshot.getCurrentScore());
        }
    }

    @NotNull
    @Generated
    public String getPlayerName() {
        return this.playerName;
    }

    @NotNull
    @Generated
    public List<LeaderBoardSnapshot> getSnapshots() {
        return this.snapshots;
    }

    @Generated
    public LeaderBoardCache setPlayerName(@NotNull String playerName) {
        if (playerName == null) {
            throw new NullPointerException("playerName is marked non-null but is null");
        }
        this.playerName = playerName;
        return this;
    }

    @Generated
    public LeaderBoardCache setSnapshots(@NotNull List<LeaderBoardSnapshot> snapshots) {
        if (snapshots == null) {
            throw new NullPointerException("snapshots is marked non-null but is null");
        }
        this.snapshots = snapshots;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeaderBoardCache)) {
            return false;
        }
        LeaderBoardCache other = (LeaderBoardCache)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$playerName = this.getPlayerName();
        String other$playerName = other.getPlayerName();
        if (this$playerName == null ? other$playerName != null : !this$playerName.equals(other$playerName)) {
            return false;
        }
        List<LeaderBoardSnapshot> this$snapshots = this.getSnapshots();
        List<LeaderBoardSnapshot> other$snapshots = other.getSnapshots();
        return !(this$snapshots == null ? other$snapshots != null : !((Object)this$snapshots).equals(other$snapshots));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LeaderBoardCache;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $playerName = this.getPlayerName();
        result = result * 59 + ($playerName == null ? 43 : $playerName.hashCode());
        List<LeaderBoardSnapshot> $snapshots = this.getSnapshots();
        result = result * 59 + ($snapshots == null ? 43 : ((Object)$snapshots).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LeaderBoardCache(playerName=" + this.getPlayerName() + ", snapshots=" + String.valueOf(this.getSnapshots()) + ")";
    }

    @Generated
    public LeaderBoardCache() {
    }

    @Generated
    public LeaderBoardCache(@NotNull String playerName, @NotNull List<LeaderBoardSnapshot> snapshots) {
        if (playerName == null) {
            throw new NullPointerException("playerName is marked non-null but is null");
        }
        if (snapshots == null) {
            throw new NullPointerException("snapshots is marked non-null but is null");
        }
        this.playerName = playerName;
        this.snapshots = snapshots;
    }
}

