/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.nametag.service;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import mod.fuji.core.annotation.Unused;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.player.PlayerTeleportPreEvent;
import mod.fuji.core.event.message.player.PlayerWorldChangedEvent;
import mod.fuji.core.event.message.server.tick.ServerTickEndEvent;
import mod.fuji.module.initializer.nametag.NametagInitializer;
import mod.fuji.module.initializer.nametag.structure.NametagEntity;
import mod.fuji.module.initializer.nametag.structure.NametagEntitySyncer;
import mod.fuji.module.initializer.nametag.structure.NametagPlayerPreferences;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class NametagService {
    public static Map<class_3222, NametagEntity> nametagEntityMap = new ConcurrentHashMap<class_3222, NametagEntity>();

    public static void refreshNametagEntities() {
        nametagEntityMap.values().removeIf(NametagEntity::shouldRemove);
        PlayerHelper.Lookup.getOnlinePlayers().forEach(NametagService::refreshNametagEntity);
    }

    private static void refreshNametagEntity(@NotNull class_3222 player) {
        if (NametagService.getNametagEntityRemovalReason(player).isPresent()) {
            return;
        }
        NametagEntity nametagEntity = Optional.ofNullable(nametagEntityMap.get(player)).orElseGet(() -> NametagService.setupNametagEntity(player));
        nametagEntity.updateTrackedData();
    }

    @NotNull
    private static NametagEntity setupNametagEntity(@NotNull class_3222 player) {
        NametagEntity nametagEntity = NametagEntity.make(player);
        nametagEntityMap.put(player, nametagEntity);
        NametagEntitySyncer.syncNametagEntityToClientWorld(nametagEntity);
        return nametagEntity;
    }

    public static Optional<NametagEntity> getNametagEntity(@NotNull class_3222 player) {
        return Optional.ofNullable(nametagEntityMap.get(player));
    }

    @EventConsumer
    private static void tickNametagEntities(@Unused ServerTickEndEvent event) {
        nametagEntityMap.values().forEach(NametagEntity::method_5773);
    }

    private static void removeNametagEntity(class_3222 player) {
        Optional.ofNullable(nametagEntityMap.get(player)).ifPresent(NametagEntity::setRemoved);
    }

    @EventConsumer(injectorPriority=2000)
    private static void consumePlayerTeleportPreEvent(PlayerTeleportPreEvent event) {
        if (event.getCallbackInfo().isCancelled()) {
            return;
        }
        NametagService.removeNametagEntity(event.getPlayer());
    }

    @EventConsumer
    private static void consumePlayerWorldChangedEvent(PlayerWorldChangedEvent event) {
        NametagService.removeNametagEntity(event.getPlayer());
    }

    public static void removeAllNametagEntities() {
        nametagEntityMap.values().forEach(NametagEntity::setRemoved);
    }

    @NotNull
    public static NametagPlayerPreferences getOrCreateNametagPlayerPreferences(@NotNull class_3222 player) {
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        return NametagInitializer.data.model().getPreferences().computeIfAbsent(playerName, key -> new NametagPlayerPreferences());
    }

    public static boolean shouldRenderNametagEntity(@NotNull NametagEntity nametagEntity) {
        class_3222 ownerPlayer = nametagEntity.getOwnerPlayer();
        if (ownerPlayer.method_5715()) {
            return false;
        }
        return !ownerPlayer.method_5767();
    }

    public static Optional<String> getNametagEntityRemovalReason(@NotNull class_3222 ownerPlayer) {
        if (ownerPlayer.method_29504()) {
            return Optional.of("The entity is dead.");
        }
        if (ownerPlayer.method_35049() != null) {
            return Optional.of("The entity is removed.");
        }
        if (!NametagService.getOrCreateNametagPlayerPreferences(ownerPlayer).isEnableNametagEntity()) {
            return Optional.of("The player has turn off the nametag entity.");
        }
        return Optional.empty();
    }
}

