/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.service.paged_text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.service.command_callback.CommandCallbackManager;
import mod.fuji.core.service.paged_text.PagedText;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;

public class PagedMessageText
extends PagedText {
    public PagedMessageText(class_3222 player, String string) {
        String[] split = string.split("<newpage>");
        this.pages = new ArrayList();
        Arrays.stream(split).forEach(it -> this.pages.add(TextHelper.getTextByValue(player, it, new Object[0])));
        this.generateClickCallbacks(player);
    }

    public PagedMessageText(class_3222 player, List<class_2561> pages) {
        this.pages = pages;
        this.generateClickCallbacks(player);
    }

    @NotNull
    public static <T> PagedMessageText makePagedMessageText(class_3222 player, List<T> entities, int pageSize, TriConsumer<T, Integer, class_5250> entityConsumer) {
        ArrayList<class_2561> pages = new ArrayList<class_2561>();
        class_5250 pageBuilder = class_2561.method_43473();
        for (int i = 0; i < entities.size(); ++i) {
            if (i % pageSize == 0 && i != 0) {
                pages.add((class_2561)pageBuilder);
                pageBuilder = class_2561.method_43473();
            }
            T entity = entities.get(i);
            entityConsumer.accept(entity, (Object)i, (Object)pageBuilder);
            pageBuilder.method_10852(TextHelper.TEXT_NEWLINE);
            if (i != entities.size() - 1) continue;
            pages.add((class_2561)pageBuilder);
        }
        return new PagedMessageText(player, pages);
    }

    private void generateClickCallbacks(class_3222 player) {
        ArrayList<String> pageCallbacks = new ArrayList<String>();
        for (int i = 0; i < this.getPages().size(); ++i) {
            pageCallbacks.add(i, this.makeClickCallbackCommand(i));
        }
        if (pageCallbacks.size() == 1) {
            return;
        }
        int totalPages = this.getPages().size();
        for (int i = 0; i < this.getPages().size(); ++i) {
            class_5250 text = this.getPages().get(i).method_27661();
            int currentPage = i + 1;
            if (i == 0) {
                text.method_10852(TextHelper.getTextByKey(player, "echo.send_custom.custom_text.paginator.first_page", currentPage, totalPages, pageCallbacks.get(i + 1)));
            } else if (i == this.getPages().size() - 1) {
                text.method_10852(TextHelper.getTextByKey(player, "echo.send_custom.custom_text.paginator.last_page", pageCallbacks.get(i - 1), currentPage, totalPages));
            } else {
                text.method_10852(TextHelper.getTextByKey(player, "echo.send_custom.custom_text.paginator.middle_page", pageCallbacks.get(i - 1), currentPage, totalPages, pageCallbacks.get(i + 1)));
            }
            this.getPages().set(i, (class_2561)text);
        }
    }

    private String makeClickCallbackCommand(int pageIndex) {
        return CommandCallbackManager.makeCallbackCommandString(player -> {
            if (pageIndex < 0 || pageIndex >= this.getPages().size()) {
                TextHelper.sendTextByKey(player, "echo.send_custom.custom_text.invalid_page", new Object[0]);
                return;
            }
            TextHelper.sendMessageByText(player, this.getPages().get(pageIndex));
        }, 1L, TimeUnit.HOURS);
    }

    public void sendPage(class_3222 player, int pageIndex) {
        TextHelper.sendMessageByText(player, this.getPages().get(pageIndex));
    }
}

