/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.auxiliary;

import io.github.sakurawald.core.config.Configs;
import io.github.sakurawald.core.config.model.ConfigModel;
import io.github.sakurawald.core.manager.impl.module.ModuleManager;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.jetbrains.annotations.NotNull;

public final class LogUtil {
    @NotNull
    private static final Logger MOD_LOGGER = LogUtil.makeLogger(StringUtils.capitalize((String)"fuji"));
    private static final boolean isConsoleSupportAnsiColor = LogUtil.isConsoleSupportAnsiColor();

    @NotNull
    private static Logger makeLogger(String name) {
        Logger logger = LogManager.getLogger((String)name);
        try {
            String level = System.getProperty("%s.level".formatted("fuji"));
            Configurator.setLevel((Logger)logger, (Level)Level.getLevel((String)level));
        }
        catch (Exception e) {
            return logger;
        }
        return logger;
    }

    private static boolean isConsoleSupportAnsiColor() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
    }

    private static String attachSourceModuleInfo(String message) {
        String prefix = "[%s] ".formatted(LogUtil.findSourceModuleInCurrentStack());
        return prefix + message;
    }

    public static void debug(String message, Object ... args) {
        message = LogUtil.attachSourceModuleInfo(message);
        ConfigModel.Core.Debug debugConfig = Configs.configHandler.model().core.debug;
        if (debugConfig.log_debug_messages) {
            String prefix = isConsoleSupportAnsiColor ? "\u001b[37m" : "";
            String format = prefix + message;
            MOD_LOGGER.info(format, args);
        } else {
            MOD_LOGGER.debug(message, args);
        }
    }

    public static void info(String message, Object ... args) {
        message = LogUtil.attachSourceModuleInfo(message);
        MOD_LOGGER.info(message, args);
    }

    public static void warn(String message, Object ... args) {
        message = LogUtil.attachSourceModuleInfo(message);
        MOD_LOGGER.warn(message, args);
    }

    public static void error(String message, Object ... args) {
        message = LogUtil.attachSourceModuleInfo(message);
        MOD_LOGGER.error(message, args);
    }

    private static List<String> getCurrentStackTraceAsClassNames() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).map(StackTraceElement::getClassName).toList();
    }

    private static List<String> getCurrentStackTraceAsModuleName() {
        return LogUtil.getCurrentStackTraceAsClassNames().stream().map(ModuleManager::computeModulePathAsString).toList();
    }

    private static String findSourceModuleInCurrentStack() {
        return LogUtil.findSourceModule(LogUtil.getCurrentStackTraceAsModuleName());
    }

    private static String findSourceModule(List<String> joinedModulePath) {
        String result = "unknown";
        for (String moduleName : joinedModulePath) {
            result = moduleName;
            if (result.equals("core")) continue;
            return result;
        }
        return result;
    }

    private LogUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

