/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.auxiliary.minecraft;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import net.minecraft.class_1707;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;

public final class GuiHelper {
    private static final class_1792 INVALID_SLOT_PLACEHOLDER_ITEM = class_1802.field_8077;

    public static void fill(@NotNull SimpleGui gui, class_1799 itemStack) {
        for (int i = 0; i < gui.getSize(); ++i) {
            gui.setSlot(i, itemStack);
        }
    }

    public static boolean isInvalidSlotInsidePlayerInventory(int index) {
        return index == 41 || index == 42 || index == 43 || index == 44;
    }

    public static boolean isInvalidSlotPlaceholder(class_1799 stack) {
        return stack.method_7909().equals(INVALID_SLOT_PLACEHOLDER_ITEM);
    }

    public static int getRows(class_3917<class_1707> screenHandlerType) {
        if (screenHandlerType == class_3917.field_18664) {
            return 1;
        }
        if (screenHandlerType == class_3917.field_18665) {
            return 2;
        }
        if (screenHandlerType == class_3917.field_17326) {
            return 3;
        }
        if (screenHandlerType == class_3917.field_18666) {
            return 4;
        }
        if (screenHandlerType == class_3917.field_18667) {
            return 5;
        }
        if (screenHandlerType == class_3917.field_17327) {
            return 6;
        }
        throw new IllegalArgumentException("Unknown screen handler type: " + String.valueOf(screenHandlerType));
    }

    public static GuiElementBuilder hideTooltip(GuiElementBuilder builder) {
        builder.hideTooltip();
        return builder;
    }

    public static GuiElementInterface makeBarrier() {
        return GuiHelper.hideTooltip(new GuiElementBuilder().setItem(class_1802.field_8077)).build();
    }

    public static GuiElementInterface makeSlotPlaceholder() {
        return GuiHelper.hideTooltip(new GuiElementBuilder().setItem(class_1802.field_8871)).build();
    }

    public static GuiElementBuilder makeSkullButton(String skullOwner) {
        return new GuiElementBuilder().setItem(class_1802.field_8575).setSkullOwner(skullOwner);
    }

    public static GuiElementBuilder makePreviousPageButton(class_3222 player) {
        return GuiHelper.makeSkullButton("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWYxMzNlOTE5MTlkYjBhY2VmZGMyNzJkNjdmZDg3YjRiZTg4ZGM0NGE5NTg5NTg4MjQ0NzRlMjFlMDZkNTNlNiJ9fX0=").setName(TextHelper.getTextByKey(player, "previous_page", new Object[0]));
    }

    public static GuiElementBuilder makeNextPageButton(class_3222 player) {
        return GuiHelper.makeSkullButton("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTNmYzUyMjY0ZDhhZDllNjU0ZjQxNWJlZjAxYTIzOTQ3ZWRiY2NjY2Y2NDkzNzMyODliZWE0ZDE0OTU0MWY3MCJ9fX0=").setName(TextHelper.getTextByKey(player, "next_page", new Object[0]));
    }

    public static GuiElementBuilder makeBackButton(class_3222 player) {
        return GuiHelper.makeSkullButton("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWYxMzNlOTE5MTlkYjBhY2VmZGMyNzJkNjdmZDg3YjRiZTg4ZGM0NGE5NTg5NTg4MjQ0NzRlMjFlMDZkNTNlNiJ9fX0=").setName(TextHelper.getTextByKey(player, "back", new Object[0]));
    }

    public static GuiElementBuilder makeSearchButton(class_3222 player) {
        return new GuiElementBuilder().setItem(class_1802.field_8251).setName(TextHelper.getTextByKey(player, "search", new Object[0]));
    }

    public static GuiElementBuilder makeAddButton(class_3222 player) {
        return GuiHelper.makeSkullButton("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDdhMGZjNmRjZjczOWMxMWZlY2U0M2NkZDE4NGRlYTc5MWNmNzU3YmY3YmQ5MTUzNmZkYmM5NmZhNDdhY2ZiIn19fQ==").setName(TextHelper.getTextByKey(player, "add", new Object[0]));
    }

    public static GuiElementBuilder makeHelpButton(class_3222 player) {
        return GuiHelper.makeQuestionMarkButton(player).setName(TextHelper.getTextByKey(player, "help", new Object[0]));
    }

    public static GuiElementBuilder makeUnknownPlayerSkull() {
        return GuiHelper.makeSkullButton("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOWQ5Y2M1OGFkMjVhMWFiMTZkMzZiYjVkNmQ0OTNjOGY1ODk4YzJiZjMwMmI2NGUzMjU5MjFjNDFjMzU4NjcifX19");
    }

    public static GuiElementBuilder makeQuestionMarkButton(class_3222 player) {
        return GuiHelper.makeSkullButton("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZmMyNzEwNTI3MTllZjY0MDc5ZWU4YzE0OTg5NTEyMzhhNzRkYWM0YzI3Yjk1NjQwZGI2ZmJkZGMyZDZiNWI2ZSJ9fX0=");
    }

    public static GuiElementBuilder makeHeartButton(class_3222 player) {
        return GuiHelper.makeSkullButton("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMDlhNTJjYjUwOTkyZDgzYzU1OTlmZDZlNDFhNmNlOTljZjdmMWU2MjAzNjExOTYzZGMyYzJmZGEwYjU1NTgzIn19fQ==");
    }

    public static GuiElementBuilder makeLetterAButton(class_3222 player) {
        return GuiHelper.makeSkullButton("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDJjZDVhMWI1Mjg4Y2FhYTIxYTZhY2Q0Yzk4Y2VhZmQ0YzE1ODhjOGIyMDI2Yzg4YjcwZDNjMTU0ZDM5YmFiIn19fQ==");
    }

    private GuiHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class Icon {
        public static final String PLAYER_PLACEHOLDER_ICON = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOWQ5Y2M1OGFkMjVhMWFiMTZkMzZiYjVkNmQ0OTNjOGY1ODk4YzJiZjMwMmI2NGUzMjU5MjFjNDFjMzU4NjcifX19";
        public static final String PREVIOUS_PAGE_ICON = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWYxMzNlOTE5MTlkYjBhY2VmZGMyNzJkNjdmZDg3YjRiZTg4ZGM0NGE5NTg5NTg4MjQ0NzRlMjFlMDZkNTNlNiJ9fX0=";
        public static final String NEXT_PAGE_ICON = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTNmYzUyMjY0ZDhhZDllNjU0ZjQxNWJlZjAxYTIzOTQ3ZWRiY2NjY2Y2NDkzNzMyODliZWE0ZDE0OTU0MWY3MCJ9fX0=";
        public static final String PLUS_ICON = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDdhMGZjNmRjZjczOWMxMWZlY2U0M2NkZDE4NGRlYTc5MWNmNzU3YmY3YmQ5MTUzNmZkYmM5NmZhNDdhY2ZiIn19fQ==";
        public static final String HEART_ICON = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMDlhNTJjYjUwOTkyZDgzYzU1OTlmZDZlNDFhNmNlOTljZjdmMWU2MjAzNjExOTYzZGMyYzJmZGEwYjU1NTgzIn19fQ==";
        public static final String A_ICON = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDJjZDVhMWI1Mjg4Y2FhYTIxYTZhY2Q0Yzk4Y2VhZmQ0YzE1ODhjOGIyMDI2Yzg4YjcwZDNjMTU0ZDM5YmFiIn19fQ==";
        public static final String QUESTION_MARK_ICON = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZmMyNzEwNTI3MTllZjY0MDc5ZWU4YzE0OTg5NTEyMzhhNzRkYWM0YzI3Yjk1NjQwZGI2ZmJkZGMyZDZiNWI2ZSJ9fX0=";

        private Icon() {
        }
    }
}

