/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.auxiliary.minecraft;

import com.mojang.serialization.DynamicOps;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.minecraft.NbtHelper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_7225;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public final class StackHelper {
    public static final String LORE_NBT_KEY = "Lore";
    public static final String DISPLAY_NBT_KEY = "display";

    public static class_2520 toNbt(class_1799 stack, class_7225.class_7874 wrapperLookup, class_2520 nbtElement) {
        if (stack.method_7960()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return (class_2520)class_1799.field_24671.encode((Object)stack, (DynamicOps)wrapperLookup.method_57093((DynamicOps)class_2509.field_11560), (Object)nbtElement).getOrThrow();
    }

    public static class_2520 encodeAllowEmpty(class_1799 stack, class_7225.class_7874 wrapperLookup) {
        return stack.method_7960() ? new class_2487() : StackHelper.toNbt(stack, wrapperLookup, (class_2520)new class_2487());
    }

    public static Optional<class_1799> fromNbt(class_7225.class_7874 wrapperLookup, class_2520 nbtElement) {
        return class_1799.field_24671.parse((DynamicOps)wrapperLookup.method_57093((DynamicOps)class_2509.field_11560), (Object)nbtElement).resultOrPartial(string -> LogUtil.debug("Failed to decode item: '{}'", string));
    }

    public static void setCustomName(class_1799 stack, class_2561 customName) {
        stack.method_57379(class_9334.field_49631, (Object)customName);
    }

    public static boolean hasCustomName(class_1799 stack) {
        return stack.method_57824(class_9334.field_49631) != null;
    }

    public static List<class_2561> getLore(class_1799 stack) {
        return ((class_9290)stack.method_57824(class_9334.field_49632)).comp_2400();
    }

    public static void setLore(class_1799 stack, List<class_2561> texts) {
        class_9290 loreComponent = new class_9290(texts);
        stack.method_57379(class_9334.field_49632, (Object)loreComponent);
    }

    public static class_2487 getSkullOwner(class_1799 stack) {
        class_2487 nbt = NbtHelper.getNbt(stack);
        if (nbt == null) {
            return null;
        }
        return nbt.method_10562("SkullOwner");
    }

    public static boolean canCombine(class_1799 itemStack, class_1799 itemStack2) {
        if (!itemStack.method_31574(itemStack2.method_7909())) {
            return false;
        }
        if (itemStack.method_7960() && itemStack2.method_7960()) {
            return true;
        }
        return Objects.equals(NbtHelper.getNbt(itemStack), NbtHelper.getNbt(itemStack2));
    }

    private StackHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

