/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.auxiliary.minecraft;

import io.github.sakurawald.core.auxiliary.minecraft.NbtHelper;
import io.github.sakurawald.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.core.structure.GlobalBlockPos;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UuidHelper {
    private static final String FUJI_UUID = "fuji$uuid";

    @Nullable
    public static String getAttachedUuid(@Nullable class_2487 root) {
        if (root == null) {
            return null;
        }
        if (!root.method_10545(FUJI_UUID)) {
            return null;
        }
        return NbtHelper.getString(root, FUJI_UUID);
    }

    public static String getAttachedUuid(GlobalBlockPos globalBlockPos) {
        return UuidHelper.getAttachedUuid((class_1937)globalBlockPos.ofDimension(), globalBlockPos.ofBlockPos());
    }

    public static String getAttachedUuid(class_1937 world, class_2338 blockPos) {
        byte[] bytes = UuidHelper.toUuid(world, blockPos).getBytes();
        return UUID.nameUUIDFromBytes(bytes).toString();
    }

    public static String toUuid(class_1937 world, class_2338 blockPos) {
        String dimension = RegistryHelper.ofString(world);
        String pos = blockPos.method_10263() + "#" + blockPos.method_10264() + "#" + blockPos.method_10260();
        return dimension + "#" + pos;
    }

    @NotNull
    public static String getOrSetAttachedUuid(class_1799 itemStack) {
        class_2487 nbt = NbtHelper.getNbt(itemStack);
        if (UuidHelper.getAttachedUuid(nbt) == null) {
            nbt = UuidHelper.setGeneratedUuidIfAbsent(nbt);
            NbtHelper.setNbt(itemStack, nbt);
        }
        return UuidHelper.getAttachedUuid(nbt);
    }

    @NotNull
    private static class_2487 setGeneratedUuidIfAbsent(@Nullable class_2487 root) {
        if (root == null) {
            root = new class_2487();
        }
        if (!root.method_10545(FUJI_UUID)) {
            root.method_10582(FUJI_UUID, String.valueOf(UUID.randomUUID()));
        }
        return root;
    }

    private UuidHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

