/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.command.processor;

import com.mojang.brigadier.CommandDispatcher;
import io.github.sakurawald.core.annotation.Cite;
import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandRequirement;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.command.argument.adapter.abst.BaseArgumentTypeAdapter;
import io.github.sakurawald.core.command.argument.structure.Argument;
import io.github.sakurawald.core.command.structure.CommandDescriptor;
import io.github.sakurawald.core.command.structure.CommandRequirementDescriptor;
import io.github.sakurawald.core.command.structure.RetargetCommandDescriptor;
import io.github.sakurawald.core.event.impl.CommandEvents;
import io.github.sakurawald.core.manager.Managers;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2168;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;

@Cite(value={"https://github.com/Revxrsal/Lamp", "https://github.com/henkelmax/admiral"})
public class CommandAnnotationProcessor {
    private static final String REQUIRED_ARGUMENT_PLACEHOLDER = "$";
    public static final Set<CommandDescriptor> descriptors = ConcurrentHashMap.newKeySet();
    private static CommandDispatcher<class_2168> dispatcher;
    private static class_7157 registryAccess;

    public static void process() {
        CommandEvents.REGISTRATION.register((dispatcher, registryAccess, environment) -> {
            CommandAnnotationProcessor.dispatcher = dispatcher;
            CommandAnnotationProcessor.registryAccess = registryAccess;
            BaseArgumentTypeAdapter.registerAdapters();
            descriptors.clear();
            CommandAnnotationProcessor.processClasses();
        });
    }

    private static void processClasses() {
        Managers.getModuleManager().getModuleRegistry().values().stream().filter(Objects::nonNull).forEach(initializer -> CommandAnnotationProcessor.processClass(initializer.getClass()));
    }

    private static void processClass(Class<?> clazz) {
        ReflectionUtil.getMethodsWithAnnotation(clazz, CommandNode.class).forEach(method -> CommandAnnotationProcessor.processMethod(clazz, method));
    }

    private static void processMethod(Class<?> clazz, Method method) {
        if (!method.getReturnType().equals(Integer.TYPE)) {
            throw new RuntimeException("The method `%s` in class `%s` must return the primitive int data type.".formatted(method.getName(), clazz.getName()));
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new RuntimeException("The method `%s` in class `%s` must be static.".formatted(method.getName(), clazz.getName()));
        }
        CommandDescriptor descriptor = CommandAnnotationProcessor.makeCommandDescriptor(clazz, method);
        descriptor.register();
        RetargetCommandDescriptor.make(descriptor).ifPresent(CommandDescriptor::register);
    }

    private static Class<?> unbox(Parameter parameter) {
        if (parameter.getType().equals(Optional.class)) {
            ParameterizedType parameterizedType = (ParameterizedType)parameter.getParameterizedType();
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return parameter.getType();
    }

    private static boolean isRequiredArgumentPlaceholder(Argument argument) {
        return argument.getArgumentName().startsWith(REQUIRED_ARGUMENT_PLACEHOLDER);
    }

    private static int parseMethodParameterIndexFromArgumentName(Argument argument) {
        String argumentName = argument.getArgumentName();
        if (argumentName.startsWith(REQUIRED_ARGUMENT_PLACEHOLDER)) {
            return Integer.parseInt(argumentName.substring(REQUIRED_ARGUMENT_PLACEHOLDER.length()));
        }
        throw new IllegalArgumentException("failed to parse parameter index from argument name for argument" + String.valueOf(argument));
    }

    @NotNull
    private static CommandDescriptor makeCommandDescriptor(Class<?> clazz, Method method) {
        ArrayList<Argument> argumentList = new ArrayList<Argument>();
        CommandNode classAnnotation = clazz.getAnnotation(CommandNode.class);
        CommandRequirement classRequirement = clazz.getAnnotation(CommandRequirement.class);
        if (classAnnotation != null && !classAnnotation.value().isBlank()) {
            Arrays.stream(classAnnotation.value().trim().split(" ")).filter(it -> !it.isBlank()).forEach(argumentName -> argumentList.add(Argument.makeLiteralArgument(argumentName, CommandRequirementDescriptor.of(classRequirement))));
        }
        method.setAccessible(true);
        CommandNode methodAnnotation = method.getAnnotation(CommandNode.class);
        if (methodAnnotation.topLevel()) {
            argumentList.clear();
        }
        CommandRequirement methodRequirement = null;
        for (String argumentName2 : Arrays.stream(methodAnnotation.value().trim().split(" ")).filter(node -> !node.isBlank()).toList()) {
            methodRequirement = method.getAnnotation(CommandRequirement.class);
            if (methodRequirement == null) {
                methodRequirement = classRequirement;
            }
            argumentList.add(Argument.makeLiteralArgument(argumentName2, CommandRequirementDescriptor.of(methodRequirement)));
        }
        boolean hasAnyRequiredArgumentPlaceholder = argumentList.stream().anyMatch(CommandAnnotationProcessor::isRequiredArgumentPlaceholder);
        if (hasAnyRequiredArgumentPlaceholder) {
            for (int argumentIndex = 0; argumentIndex < argumentList.size(); ++argumentIndex) {
                Argument argument = (Argument)argumentList.get(argumentIndex);
                if (!CommandAnnotationProcessor.isRequiredArgumentPlaceholder(argument)) continue;
                int methodParameterIndex = CommandAnnotationProcessor.parseMethodParameterIndexFromArgumentName(argument);
                Parameter parameter = method.getParameters()[methodParameterIndex];
                Class<?> type = CommandAnnotationProcessor.unbox(parameter);
                boolean isOptional = parameter.getType().equals(Optional.class);
                argumentList.set(argumentIndex, Argument.makeRequiredArgument(type, parameter.getName(), isOptional, CommandRequirementDescriptor.of(methodRequirement)).markWithParameter(parameter).withDocument(parameter.getAnnotation(Document.class)));
            }
            for (int parameterIndex = 0; parameterIndex < method.getParameters().length; ++parameterIndex) {
                Parameter parameter = method.getParameters()[parameterIndex];
                if (parameter.getAnnotation(CommandSource.class) == null) continue;
                Class<?> type = CommandAnnotationProcessor.unbox(parameter);
                argumentList.add(0, Argument.makeRequiredArgument(type, parameter.getName(), false, CommandRequirementDescriptor.of(methodRequirement)).markWithParameter(parameter).withDocument(parameter.getAnnotation(Document.class)));
            }
        } else {
            Parameter[] parameters;
            for (Parameter parameter : parameters = method.getParameters()) {
                Class<?> type = CommandAnnotationProcessor.unbox(parameter);
                boolean isOptional = parameter.getType().equals(Optional.class);
                Argument argument = Argument.makeRequiredArgument(type, parameter.getName(), isOptional, CommandRequirementDescriptor.of(methodRequirement)).markWithParameter(parameter).withDocument(parameter.getAnnotation(Document.class));
                argumentList.add(argument);
            }
        }
        if (argumentList.isEmpty()) {
            throw new RuntimeException("The argument list of @CommandNode annotated in method `%s` in class `%s` is empty.".formatted(method.getName(), clazz.getName()));
        }
        return new CommandDescriptor(method, argumentList).withDocument(method.getAnnotation(Document.class));
    }

    public static CommandDispatcher<class_2168> getDispatcher() {
        return dispatcher;
    }

    public static class_7157 getRegistryAccess() {
        return registryAccess;
    }
}

